/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.OdfStylePropertySet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.type.StyleName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class OdfStylableElement
extends OdfElement
implements OdfStylePropertySet {
    private static final long serialVersionUID = -7828513537641758879L;
    private OdfStyle mAutomaticStyle;
    protected OdfStyleFamily mFamily;
    protected OdfName mStyleNameAttrib;
    private OdfSchemaDocument mOdfSchemaDocument;
    boolean misAutomaticStyleSet = false;
    ErrorHandler mErrorHandler;

    public OdfStylableElement(OdfFileDom ownerDocument, OdfName name, OdfStyleFamily family, OdfName styleNameAttrib) throws DOMException {
        super(ownerDocument, name.getUri(), name.getQName());
        this.mFamily = family;
        this.mStyleNameAttrib = styleNameAttrib;
        this.mOdfSchemaDocument = (OdfSchemaDocument)ownerDocument.getDocument();
        this.mErrorHandler = ownerDocument.getDocument().getPackage().getErrorHandler();
    }

    private StyleStyleElement createAutomaticStyle(Boolean createStyleName, OdfStyleFamily styleFamily) {
        if (styleFamily == null) {
            styleFamily = this.getStyleFamily();
        }
        if (this.mAutomaticStyle == null || this.mAutomaticStyle.getStyleUserCount() > 1) {
            OdfOfficeAutomaticStyles automatic_styles = this.getOrCreateAutomaticStyles();
            if (automatic_styles == null) {
                OdfFileDom fileDom = (OdfFileDom)this.getOwnerDocument();
                OdfOfficeAutomaticStyles newOfficeAutoStyles = fileDom.newOdfElement(OdfOfficeAutomaticStyles.class);
                OdfElement rootElement = fileDom.getRootElement();
                NodeList rootChildren = rootElement.getChildNodes();
                boolean hasInserted = false;
                for (int i = 0; i < rootChildren.getLength(); ++i) {
                    String elementName;
                    Node currentNode = rootChildren.item(i);
                    if (!(currentNode instanceof Element) || !(elementName = ((Element)currentNode).getNodeName()).equals("office:body") && !elementName.equals("office:master-styles")) continue;
                    rootElement.insertBefore(newOfficeAutoStyles, currentNode);
                    hasInserted = true;
                    break;
                }
                if (!hasInserted) {
                    rootElement.appendChild(newOfficeAutoStyles);
                }
                automatic_styles = newOfficeAutoStyles;
            }
            if (automatic_styles != null) {
                String styleName = this.getStyleName();
                String parentName = null;
                this.mAutomaticStyle = automatic_styles.getStyle(styleName, styleFamily);
                if (this.mAutomaticStyle == null) {
                    this.mAutomaticStyle = automatic_styles.newStyle(styleFamily);
                    if (!styleName.isEmpty()) {
                        this.mAutomaticStyle.setStyleParentStyleNameAttribute(styleName);
                    }
                } else {
                    parentName = this.mAutomaticStyle.getStyleParentStyleNameAttribute();
                    this.mAutomaticStyle.removeStyleUser(this);
                    this.mAutomaticStyle = automatic_styles.makeStyleUnique(this.mAutomaticStyle);
                    if (parentName != null && !parentName.isEmpty()) {
                        this.mAutomaticStyle.setStyleParentStyleNameAttribute(parentName);
                    }
                }
                this.mAutomaticStyle.addStyleUser(this);
                if (createStyleName.booleanValue()) {
                    this.setStyleName(this.mAutomaticStyle.getStyleNameAttribute());
                }
            }
        }
        return this.mAutomaticStyle;
    }

    public StyleStyleElement getOrCreateUnqiueAutomaticStyle() {
        return this.createAutomaticStyle(Boolean.TRUE, null);
    }

    public StyleStyleElement getOrCreateUnqiueAutomaticStyle(Boolean createStyleName, OdfStyleFamily styleFamily) {
        return this.createAutomaticStyle(createStyleName, styleFamily);
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {
        OdfFileDom fileDom = (OdfFileDom)this.ownerDocument;
        if (fileDom != null) {
            if (fileDom instanceof OdfContentDom) {
                return ((OdfContentDom)fileDom).getOrCreateAutomaticStyles();
            }
            if (fileDom instanceof OdfStylesDom) {
                return ((OdfStylesDom)fileDom).getOrCreateAutomaticStyles();
            }
            return null;
        }
        return null;
    }

    public OdfOfficeAutomaticStyles getAutomaticStyles() {
        OdfFileDom fileDom = (OdfFileDom)this.ownerDocument;
        if (fileDom != null) {
            if (fileDom instanceof OdfContentDom) {
                return ((OdfContentDom)fileDom).getAutomaticStyles();
            }
            if (fileDom instanceof OdfStylesDom) {
                return ((OdfStylesDom)fileDom).getAutomaticStyles();
            }
            return null;
        }
        return null;
    }

    @Override
    public void setAttributeNS(String uri, String qname, String value) {
        super.setAttributeNS(uri, qname, value);
        if (this.mStyleNameAttrib.equals(uri, qname)) {
            OdfStyle autoStyle = null;
            if (this.mAutomaticStyle == null || !this.mAutomaticStyle.getStyleNameAttribute().equals(value)) {
                OdfOfficeAutomaticStyles automatic_styles = this.getAutomaticStyles();
                if (automatic_styles != null) {
                    autoStyle = automatic_styles.getStyle(value, this.getStyleFamily());
                }
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.removeStyleUser(this);
                }
                this.mAutomaticStyle = autoStyle;
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.addStyleUser(this);
                }
                if (this.mErrorHandler != null && !StyleName.isValid(value)) {
                    try {
                        this.mErrorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_XML_INVALID_ATTRIBUTE_VALUE, value, "qname"));
                    }
                    catch (SAXException ex) {
                        Logger.getLogger(StyleStyleElement.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public String getStyleName() {
        return this.getAttributeNS(this.mStyleNameAttrib.getUri(), this.mStyleNameAttrib.getLocalName());
    }

    public void setStyleName(String name) {
        this.setAttributeNS(this.mStyleNameAttrib.getUri(), this.mStyleNameAttrib.getQName(), name);
        this.misAutomaticStyleSet = false;
    }

    public OdfStyle getAutomaticStyle() {
        if (!this.misAutomaticStyleSet) {
            OdfOfficeAutomaticStyles automatic_styles = this.getAutomaticStyles();
            if (automatic_styles != null) {
                this.mAutomaticStyle = automatic_styles.getStyle(this.getStyleName(), this.getStyleFamily());
            }
            this.misAutomaticStyleSet = true;
        }
        return this.mAutomaticStyle;
    }

    public boolean hasAutomaticStyle() {
        if (!this.misAutomaticStyleSet) {
            this.getAutomaticStyle();
        }
        return this.mAutomaticStyle != null;
    }

    public OdfStyle reuseDocumentStyle(String styleName) {
        OdfStyle style = null;
        if (styleName != null && (style = this.mOdfSchemaDocument.getDocumentStyles().getStyle(styleName, this.getStyleFamily())) != null) {
            this.setDocumentStyle(style);
        }
        return style;
    }

    public void setDocumentStyle(OdfStyle style) {
        if (!this.misAutomaticStyleSet) {
            this.getAutomaticStyle();
        }
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.setStyleParentStyleNameAttribute(style.getStyleNameAttribute());
        } else {
            this.setStyleName(style.getStyleNameAttribute());
        }
    }

    public OdfStyle getDocumentStyle() {
        OdfStyle odfStyle = null;
        String styleName = this.getDocumentStyleName();
        OdfOfficeStyles documentStyles = this.mOdfSchemaDocument.getDocumentStyles();
        if (documentStyles != null) {
            odfStyle = documentStyles.getStyle(styleName, this.getStyleFamily());
        }
        return odfStyle;
    }

    public String getDocumentStyleName() {
        String styleName = null;
        if (!this.misAutomaticStyleSet) {
            this.getAutomaticStyle();
        }
        if (this.mAutomaticStyle != null) {
            styleName = this.mAutomaticStyle.getStyleParentStyleNameAttribute();
        } else {
            String automaticStyleName = this.getStyleName();
            OdfOfficeStyles officeStyles = this.mOdfSchemaDocument.getDocumentStyles();
            if (officeStyles != null && officeStyles.getStyle(automaticStyleName, this.getStyleFamily()) != null) {
                styleName = automaticStyleName;
            }
        }
        return styleName;
    }

    public boolean hasDocumentStyle() {
        String documentStyleName = this.getDocumentStyleName();
        return documentStyleName != null && !documentStyleName.isEmpty() && !documentStyleName.equals("null");
    }

    public OdfStyleFamily getStyleFamily() {
        return this.mFamily;
    }

    @Override
    public String getProperty(OdfStyleProperty property) {
        OdfStyle style;
        if (!this.misAutomaticStyleSet) {
            this.getAutomaticStyle();
        }
        if ((style = this.mAutomaticStyle) == null) {
            style = this.getOfficeStyle();
        }
        if (style != null) {
            return style.getProperty(property);
        }
        return null;
    }

    @Override
    public Map<OdfStyleProperty, String> getProperties(Set<OdfStyleProperty> properties) {
        HashMap<OdfStyleProperty, String> map = new HashMap<OdfStyleProperty, String>();
        for (OdfStyleProperty property : properties) {
            map.put(property, this.getProperty(property));
        }
        return map;
    }

    @Override
    public Set<OdfStyleProperty> getStrictProperties() {
        return this.getStyleFamily().getProperties();
    }

    @Override
    public boolean hasProperty(OdfStyleProperty property) {
        if (!this.misAutomaticStyleSet) {
            this.getAutomaticStyle();
        }
        return this.mAutomaticStyle != null && this.mAutomaticStyle.hasProperty(property);
    }

    @Override
    public void removeProperty(OdfStyleProperty property) {
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.removeProperty(property);
        }
    }

    @Override
    public void setProperties(Map<OdfStyleProperty, String> properties) {
        for (Map.Entry<OdfStyleProperty, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(OdfStyleProperty property, String value) {
        this.getOrCreateUnqiueAutomaticStyle().setProperty(property, value);
    }

    @Override
    protected void onInsertNode() {
        OdfOfficeAutomaticStyles automatic_styles;
        super.onInsertNode();
        String stylename = this.getStyleName();
        if (stylename.length() != 0 && (automatic_styles = this.getAutomaticStyles()) != null) {
            if (!this.misAutomaticStyleSet) {
                this.getAutomaticStyle();
            }
            if (this.mAutomaticStyle != null) {
                this.mAutomaticStyle.addStyleUser(this);
            }
        }
    }

    @Override
    protected void onRemoveNode() {
        super.onInsertNode();
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.removeStyleUser(this);
            this.mAutomaticStyle = null;
            this.misAutomaticStyleSet = false;
        }
    }

    private OdfStyle getOfficeStyle() {
        OdfOfficeStyles styles = this.mOdfSchemaDocument.getDocumentStyles();
        if (styles != null) {
            return styles.getStyle(this.getStyleName(), this.getStyleFamily());
        }
        return null;
    }
}

