/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.odftoolkit.odfdom.changes.ChangesFileSaxHandler;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfContentOrStylesDomBase;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeStylesElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileSaxHandler;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class OdfStylesDom
extends OdfContentOrStylesDomBase {
    private static final long serialVersionUID = 766167617530147886L;

    public OdfStylesDom(OdfSchemaDocument odfDocument, String packagePath) {
        super(odfDocument, packagePath);
    }

    @Override
    protected void initialize() throws SAXException, IOException, ParserConfigurationException {
        block7: {
            for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
                this.mUriByPrefix.put(name.getPrefix(), name.getUri());
                this.mPrefixByUri.put(name.getUri(), name.getPrefix());
            }
            try {
                if (this.mPackageDocument instanceof OdfTextDocument && ((OdfDocument)this.mPackageDocument).hasCollaboration().booleanValue()) {
                    super.initialize(new ChangesFileSaxHandler(this), this);
                } else {
                    super.initialize(new OdfFileSaxHandler(this), this);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
                OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITH_EXISTENT_BUT_UNREADABLE_CONTENT_OR_STYLES_XML, this.mPackage.getBaseURI(), ex, OdfSchemaDocument.OdfXMLFile.STYLES.getFileName());
                ErrorHandler eh = this.mPackage.getErrorHandler();
                if (eh == null) break block7;
                try {
                    eh.error(ve);
                }
                catch (SAXException ex1) {
                    Logger.getLogger(OdfStylesDom.class.getName()).log(Level.SEVERE, null, ex1);
                    throw ex1;
                }
            }
        }
    }

    @Override
    public OfficeDocumentStylesElement getRootElement() {
        return (OfficeDocumentStylesElement)this.getDocumentElement();
    }

    public OdfOfficeStyles getOfficeStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeStyles.class, this.getFirstChild());
    }

    public OdfOfficeStyles getOrCreateOfficeStyles() {
        OdfOfficeStyles officeStyles = this.getOfficeStyles();
        if (officeStyles == null) {
            officeStyles = this.newOdfElement(OfficeStylesElement.class);
            Node parent = this.getFirstChild();
            OdfStylesBase sibling = OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, parent);
            if (sibling != null) {
                parent.insertBefore(officeStyles, sibling);
            } else {
                sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
                if (sibling != null) {
                    parent.insertBefore(officeStyles, sibling);
                } else {
                    parent.appendChild(officeStyles);
                }
            }
        }
        return officeStyles;
    }

    public OfficeAutomaticStylesElement getAutomaticStyles() {
        return OdfElement.findFirstChildNode(OfficeAutomaticStylesElement.class, this.getFirstChild());
    }

    public OfficeMasterStylesElement getMasterStyles() {
        return OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, this.getFirstChild());
    }

    public OfficeMasterStylesElement getOrCreateMasterStyles() {
        OfficeMasterStylesElement masterStyles = this.getMasterStyles();
        if (masterStyles == null) {
            masterStyles = this.newOdfElement(OfficeMasterStylesElement.class);
            Node parent = this.getFirstChild();
            parent.appendChild(masterStyles);
        }
        return masterStyles;
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {
        OdfOfficeAutomaticStyles automaticStyles = this.getAutomaticStyles();
        if (automaticStyles == null) {
            automaticStyles = this.newOdfElement(OfficeAutomaticStylesElement.class);
            Node parent = this.getFirstChild();
            OdfOfficeMasterStyles sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
            if (sibling != null) {
                parent.insertBefore(automaticStyles, sibling);
            } else {
                parent.appendChild(automaticStyles);
            }
        }
        return automaticStyles;
    }
}

