/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentMetaElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMetaElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.xml.sax.SAXException;

public class OdfMetaDom
extends OdfFileDom {
    private static final long serialVersionUID = 766167617530147884L;

    public OdfMetaDom(OdfSchemaDocument odfDocument, String packagePath) {
        super(odfDocument, packagePath);
        OfficeDocumentMetaElement rootElement = this.getRootElement();
        if (rootElement == null) {
            rootElement = new OfficeDocumentMetaElement(this);
            this.appendChild(rootElement);
            OfficeMetaElement officeMetaElement = new OfficeMetaElement(this);
            rootElement.appendChild(officeMetaElement);
        }
    }

    @Override
    protected void initialize() {
        for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
            this.mUriByPrefix.put(name.getPrefix(), name.getUri());
            this.mPrefixByUri.put(name.getUri(), name.getPrefix());
        }
        try {
            super.initialize();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(OdfMetaDom.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public OdfSchemaDocument getDocument() {
        return (OdfSchemaDocument)this.mPackageDocument;
    }

    @Override
    public final OfficeDocumentMetaElement getRootElement() {
        return (OfficeDocumentMetaElement)this.getDocumentElement();
    }

    @Override
    public XPath getXPath() {
        if (this.mXPath == null) {
            this.mXPath = XPathFactory.newInstance().newXPath();
            this.mXPath.setNamespaceContext(this);
            for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
                this.mUriByPrefix.put(name.getPrefix(), name.getUri());
                this.mPrefixByUri.put(name.getUri(), name.getPrefix());
            }
        }
        return this.mXPath;
    }
}

