/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.odftoolkit.odfdom.changes.ChangesFileSaxHandler;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfContentOrStylesDomBase;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentContentElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileSaxHandler;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class OdfContentDom
extends OdfContentOrStylesDomBase {
    private static final long serialVersionUID = 766167617530147883L;

    public OdfContentDom(OdfSchemaDocument odfDocument, String packagePath) {
        super(odfDocument, packagePath);
    }

    @Override
    protected void initialize() throws SAXException, IOException, ParserConfigurationException {
        block7: {
            for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
                this.mUriByPrefix.put(name.getPrefix(), name.getUri());
                this.mPrefixByUri.put(name.getUri(), name.getPrefix());
            }
            try {
                if (this.mPackageDocument instanceof OdfTextDocument && ((OdfDocument)this.mPackageDocument).hasCollaboration().booleanValue()) {
                    super.initialize(new ChangesFileSaxHandler(this), this);
                } else {
                    super.initialize(new OdfFileSaxHandler(this), this);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
                OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITH_EXISTENT_BUT_UNREADABLE_CONTENT_OR_STYLES_XML, this.mPackage.getBaseURI(), ex, OdfSchemaDocument.OdfXMLFile.STYLES.getFileName());
                ErrorHandler eh = this.mPackage.getErrorHandler();
                if (eh == null) break block7;
                try {
                    eh.error(ve);
                }
                catch (SAXException ex1) {
                    Logger.getLogger(OdfStylesDom.class.getName()).log(Level.SEVERE, null, ex1);
                    throw ex1;
                }
            }
        }
    }

    @Override
    public OfficeDocumentContentElement getRootElement() {
        return (OfficeDocumentContentElement)this.getDocumentElement();
    }

    public OdfOfficeAutomaticStyles getAutomaticStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, this.getFirstChild());
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {
        OdfOfficeAutomaticStyles automaticStyles = this.getAutomaticStyles();
        if (automaticStyles == null) {
            automaticStyles = this.newOdfElement(OfficeAutomaticStylesElement.class);
            Node parent = this.getFirstChild();
            OdfElement sibling = OdfElement.findFirstChildNode(OfficeBodyElement.class, parent);
            if (sibling == null) {
                sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
            }
            if (sibling == null) {
                parent.appendChild(automaticStyles);
            } else {
                parent.insertBefore(automaticStyles, sibling);
            }
        }
        return automaticStyles;
    }
}

