/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.changes.TextHyperlinkSelection;
import org.odftoolkit.odfdom.changes.TextSelection;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public abstract class TextContainingElement
extends OdfStylableElement {
    private static final Logger LOG = Logger.getLogger(TextContainingElement.class.getName());
    private TreeSet<TextSelection> mSelections = null;

    public TextContainingElement(OdfFileDom ownerDoc, OdfName elementName, OdfStyleFamily styleFamily, OdfName styleAttrName) {
        super(ownerDoc, elementName, styleFamily, styleAttrName);
    }

    @Override
    public OdfName getOdfName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OdfElement appendTextSelection(TextSelection outerSelection) {
        if (this.mSelections == null) {
            SelectionComparator c = new SelectionComparator();
            this.mSelections = new TreeSet<TextSelection>(c);
        }
        OdfElement parentElement = (OdfElement)outerSelection.mSelectionElement.getParentNode();
        if ((outerSelection.mSelectionElement instanceof TextSpanElement || outerSelection.mSelectionElement instanceof TextAElement) && outerSelection.mSelectionElement.getChildNodes().getLength() != 0) {
            if (outerSelection.mSelectionElement instanceof TextAElement) {
                TextAElement outerAnchor = (TextAElement)outerSelection.mSelectionElement;
                String url = outerAnchor.getXlinkHrefAttribute();
                TextHyperlinkSelection overlappingInnerSelection = ((TextHyperlinkSelection)outerSelection).getOverLappingHyperlinkSelection(this.mSelections);
                if (overlappingInnerSelection != null) {
                    outerAnchor.split((Integer)overlappingInnerSelection.mEndPosition.get(overlappingInnerSelection.mEndPosition.size() - 1));
                    OdfElement newMiddlePart = outerAnchor.split((Integer)overlappingInnerSelection.mStartPosition.get(overlappingInnerSelection.mStartPosition.size() - 1));
                    OdfElement.removeSingleElement(newMiddlePart);
                } else if (url == null || url.isEmpty() || url.equals("null")) {
                    parentElement = (OdfElement)OdfElement.removeSingleElement(outerAnchor);
                } else if (this.mSelections.contains(outerSelection)) {
                    NavigableSet<TextSelection> equalSet = this.mSelections.subSet(outerSelection, true, outerSelection, true);
                    if (equalSet.size() < 2) {
                        for (TextSelection innerSelection : equalSet) {
                            if (innerSelection.mSelectionElement instanceof TextSpanElement) {
                                if (innerSelection.getURL() == null) {
                                    innerSelection.setURL(url);
                                    parentElement = (OdfElement)outerAnchor.getParentNode();
                                } else {
                                    parentElement = (OdfElement)OdfElement.removeSingleElement(outerAnchor);
                                }
                                break;
                            }
                            if (innerSelection.mSelectionElement instanceof TextAElement) {
                                parentElement = (OdfElement)OdfElement.removeSingleElement(outerAnchor);
                                continue;
                            }
                            this.mSelections.add(outerSelection);
                            parentElement = (OdfElement)outerSelection.mSelectionElement.getParentNode();
                        }
                    } else {
                        parentElement = (OdfElement)OdfElement.removeSingleElement(outerAnchor);
                    }
                } else {
                    this.mSelections.add(outerSelection);
                }
            } else if (this.mSelections.contains(outerSelection)) {
                NavigableSet<TextSelection> equalSet = this.mSelections.subSet(outerSelection, true, outerSelection, true);
                TextSelection innerSelection = null;
                Iterator it = equalSet.iterator();
                parentElement = (OdfElement)outerSelection.mSelectionElement.getParentNode();
                while (it.hasNext()) {
                    innerSelection = (TextSelection)it.next();
                    if (innerSelection.mSelectionElement instanceof TextSpanElement) {
                        OdfStylableElement innerElement = (OdfStylableElement)innerSelection.getSelectionElement();
                        OdfStylableElement outerElement = (OdfStylableElement)outerSelection.getSelectionElement();
                        OdfStyle.mergeSelectionWithSameRange(innerElement, outerElement);
                        continue;
                    }
                    String url = innerSelection.getURL();
                    this.mSelections.remove(innerSelection);
                    outerSelection.setURL(url);
                    this.mSelections.add(outerSelection);
                }
            } else {
                this.mSelections.add(outerSelection);
            }
        } else {
            parentElement.removeChild(outerSelection.mSelectionElement);
        }
        return parentElement;
    }

    public Collection<TextSelection> getTextSelections() {
        return this.mSelections;
    }

    private class SelectionComparator
    implements Comparator<TextSelection> {
        private SelectionComparator() {
        }

        @Override
        public int compare(TextSelection o1, TextSelection o2) {
            int firstGreater = o1.compareTo(o2);
            return firstGreater;
        }
    }
}

