/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.TextContainingElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TextContainer<T>
extends Component {
    public TextContainer(OdfElement componentElement, Component parent) {
        super(componentElement, parent);
    }

    public void appendText(Text text) {
        this.mRootElement.appendChild(text);
    }

    public void removeText(int start, int end) {
        ((TextContainingElement)this.mRootElement).delete(start, end);
    }

    public Node appendChild(Node node) {
        Node newNode = this.mRootElement.appendChild(node);
        return newNode;
    }

    @Override
    public void addChild(int index, Component c) {
        this.mRootElement.insert(c.getRootElement(), index);
    }

    @Override
    public Node getChildNode(int index) {
        return this.mRootElement.receiveNode(index);
    }

    @Override
    public Node getChildNode(int startIndex, int endIndex) {
        return this.mRootElement.receiveNode(startIndex, endIndex);
    }

    @Override
    public Node remove(int index) {
        Node node = this.getChildNode(index);
        return this.mRootElement.removeChild(node);
    }

    @Override
    public int size() {
        return this.mRootElement.componentSize();
    }

    private int findChild(Node parent, int size, Node targetNode) {
        Node child;
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength() && (child = children.item(i)) != targetNode; ++i) {
            if (child instanceof Text) {
                size += ((Text)child).getLength();
                continue;
            }
            if (!(child instanceof Element)) continue;
            if (Component.isTextSelection(child)) {
                size = this.findChild(child, size, targetNode);
                continue;
            }
            if (!(child instanceof OdfElement) || !((OdfElement)child).isComponentRoot()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int indexOf(Object o) {
        Node targetNode = null;
        if (o instanceof Component) {
            targetNode = ((Component)o).getRootElement();
        } else if (o instanceof Node) {
            targetNode = (Node)o;
        }
        int position = 0;
        if (targetNode != null) {
            position += this.findChild(this.mRootElement, position, targetNode);
        }
        return position;
    }
}

