/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.type.Length;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Table<T>
extends Component {
    private static final Logger LOG = Logger.getLogger(Table.class.getName());
    public static final int ETERNITY = -1;
    static final int BEFORE_START = -1;
    public static final Integer MAX_ROW_NUMBER = 0x100000;
    public static final Integer MAX_COLUMN_NUMBER_CALC = 1024;
    public static final Integer MAX_COLUMN_NUMBER_EXCEL = 16384;
    private List<JSONArray> mColumnWidthCache = null;
    private JSONArray mTablePositionOfColumnChange;

    public Table(OdfElement componentElement, Component parent) {
        super(componentElement, parent);
    }

    @Override
    public int repetition() {
        return this.mRootElement.getRepetition();
    }

    public List getChildren() {
        return this.list(this);
    }

    private List<Component> list(final Table tableComponent) {
        return new AbstractList<Component>(){

            @Override
            public int size() {
                return tableComponent.size();
            }

            @Override
            public Component get(int index) {
                Component c = null;
                TableTableElement tableRoot = (TableTableElement)tableComponent.getRootElement();
                OdfTable table = OdfTable.getInstance(tableRoot);
                OdfTableRow row = table.getRowByIndex(index);
                if (row != null) {
                    c = row.getOdfElement().getComponent();
                }
                return c;
            }
        };
    }

    @Override
    public void addChild(int index, Component c) {
        this.mRootElement.insert(c.getRootElement(), index);
    }

    @Override
    public Node getChildNode(int index) {
        return this.mRootElement.receiveNode(index);
    }

    @Override
    public Node remove(int index) {
        Node node = this.getChildNode(index);
        return this.mRootElement.removeChild(node);
    }

    @Override
    public int size() {
        OdfTable table = OdfTable.getInstance((TableTableElement)this.mRootElement);
        return table.getRowCount();
    }

    public static String getProperty(OdfStyleProperty prop, OdfStylableElement element) {
        String value = null;
        OdfStyle style = element.getAutomaticStyle();
        if (style == null) {
            element.getOrCreateUnqiueAutomaticStyle();
            style = element.getAutomaticStyle();
            if (style == null) {
                style = element.getDocumentStyle();
            }
        }
        if (style != null) {
            value = style.getProperty(prop);
        }
        return value;
    }

    private static Length getPropertyLength(OdfStyleProperty prop, OdfStylableElement element) {
        Length length = null;
        String propValue = Table.getProperty(prop, element);
        if (propValue != null && !propValue.isEmpty()) {
            length = new Length(propValue);
        }
        return length;
    }

    public static List<Integer> collectColumnWidths(TableTableElement tableElement, List<TableTableColumnElement> columns) {
        boolean hasRelColumnWidth = false;
        boolean hasAbsColumnWidth = false;
        boolean hasColumnWithoutWidth = false;
        ArrayList<Integer> columnRelWidths = new ArrayList<Integer>();
        for (TableTableColumnElement column : columns) {
            int i;
            int widthFactor;
            String columnRelWidth;
            if (!column.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name")) continue;
            Length tableWidth = Table.getPropertyLength(StyleTablePropertiesElement.Width, tableElement);
            int repeatedColumns = 1;
            if (column.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")) {
                repeatedColumns = Integer.parseInt(column.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated"));
            }
            if ((columnRelWidth = Table.getProperty(StyleTableColumnPropertiesElement.RelColumnWidth, column)) != null && !columnRelWidth.isEmpty()) {
                hasRelColumnWidth = true;
                if (hasAbsColumnWidth) {
                    LOG.warning("******* BEWARE: Absolute and relative width are not supposed to be mixed!! ***********");
                }
                columnRelWidth = columnRelWidth.substring(0, columnRelWidth.indexOf(42));
                Integer relWidth = Integer.parseInt(columnRelWidth);
                for (int i2 = 0; i2 < repeatedColumns; ++i2) {
                    columnRelWidths.add(relWidth);
                }
                continue;
            }
            if (hasRelColumnWidth) {
                LOG.warning("******* BEWARE: Absolute and relative width are not supposed to be mixed!! ***********");
            }
            Length columnWidth = Table.getPropertyLength(StyleTableColumnPropertiesElement.ColumnWidth, column);
            if (tableWidth != null) {
                if (columnWidth != null) {
                    hasAbsColumnWidth = true;
                    widthFactor = (int)Math.round(columnWidth.getMillimeters() * 100.0 / tableWidth.getMillimeters());
                    for (i = 0; i < repeatedColumns; ++i) {
                        columnRelWidths.add(widthFactor);
                    }
                    continue;
                }
                if (hasColumnWithoutWidth) {
                    LOG.warning("******* BEWARE: Two columns without width and no column width are not expected!! ***********");
                }
                hasColumnWithoutWidth = true;
                continue;
            }
            if (columnWidth != null) {
                hasAbsColumnWidth = true;
                widthFactor = (int)Math.round(columnWidth.getMicrometer() * 10.0);
                for (i = 0; i < repeatedColumns; ++i) {
                    columnRelWidths.add(widthFactor);
                }
                continue;
            }
            LOG.warning("******* BEWARE: Two columns without width and no column width are not expected!! ***********");
        }
        return columnRelWidths;
    }

    static void stashColumnWidths(TableTableElement tableElement) {
        List<TableTableColumnElement> existingColumnList = Table.getTableColumnElements(tableElement, new LinkedList());
        List<Integer> tableColumWidths = Table.collectColumnWidths(tableElement, existingColumnList);
        ((Table)tableElement.getComponent()).pushTableGrid(tableColumWidths);
    }

    public static List<TableTableColumnElement> getTableColumnElements(Element parent, List columns) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            if (child instanceof TableTableColumnElement) {
                columns.add((TableTableColumnElement)child);
                continue;
            }
            if (child instanceof TableTableColumnGroupElement || child instanceof TableTableHeaderColumnsElement || child instanceof TableTableColumnsElement) {
                columns = Table.getTableColumnElements((Element)child, columns);
                continue;
            }
            if (child instanceof TableTableRowGroupElement || child instanceof TableTableHeaderRowsElement || child instanceof TableTableRowElement || child instanceof TableTableRowsElement) break;
        }
        return columns;
    }

    public void pushTableGrid(JSONArray tableGrid) {
        if (this.mColumnWidthCache == null) {
            this.mColumnWidthCache = new ArrayList<JSONArray>();
        }
        this.mColumnWidthCache.add(tableGrid);
    }

    public void requireLaterWidthChange(JSONArray start) {
        this.mTablePositionOfColumnChange = start;
    }

    public boolean isWidthChangeRequired() {
        return this.mTablePositionOfColumnChange != null;
    }

    public void hasChangedWidth() {
        this.mTablePositionOfColumnChange = null;
    }

    public JSONArray getPosition() {
        return this.mTablePositionOfColumnChange;
    }

    public void pushTableGrid(List<Integer> columnWidths) {
        if (columnWidths != null && !columnWidths.isEmpty()) {
            this.pushTableGrid(new JSONArray((Collection<?>)columnWidths));
        }
    }

    public JSONArray popTableGrid() {
        JSONArray previousColumnWidth = null;
        if (this.mColumnWidthCache != null && this.mColumnWidthCache.size() > 0) {
            previousColumnWidth = this.mColumnWidthCache.remove(this.mColumnWidthCache.size() - 1);
            this.mTablePositionOfColumnChange = null;
        }
        return previousColumnWidth;
    }

    public void replaceLastTableGrid(JSONArray tableGrid) {
        if (this.mColumnWidthCache == null) {
            this.mColumnWidthCache = new ArrayList<JSONArray>();
            this.mColumnWidthCache.add(tableGrid);
        } else if (this.mColumnWidthCache.size() > 0) {
            this.mColumnWidthCache.remove(this.mColumnWidthCache.size() - 1);
        }
        this.mColumnWidthCache.add(tableGrid);
    }
}

