/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.text;

import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.text.TextFactory;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class CompositeTextFactory {
    public static void appendCompositeText(Node parentNode, ResourceBundle resourceBundle, String i18nPrefix, Map<String, String> dataMap, Map<String, String> styleMap) {
        String specString = resourceBundle.getString(i18nPrefix);
        String[] majorTokens = specString.split(",");
        for (int majorTokenIndex = 0; majorTokenIndex < majorTokens.length; ++majorTokenIndex) {
            String majorToken = majorTokens[majorTokenIndex];
            String[] minorTokens = majorToken.split("\\.");
            if (minorTokens.length < 1) continue;
            String source = minorTokens[0];
            Integer currIndex = null;
            Object text = null;
            if (source.trim().length() == 0) {
                text = "";
                currIndex = 1;
            } else if ("Data".equals(source)) {
                if (minorTokens.length >= 2) {
                    if (!dataMap.containsKey(minorTokens[1])) {
                        throw new IllegalArgumentException("Expected key [" + minorTokens[1] + "] in dataMap, didn't find it.");
                    }
                    text = dataMap.get(minorTokens[1]);
                    if (text == null) {
                        text = "null";
                    }
                    currIndex = 2;
                }
            } else {
                text = resourceBundle.getString(i18nPrefix + source);
                currIndex = 1;
                if (text == null) {
                    throw new IllegalArgumentException("Expected key [" + i18nPrefix + source + "] in resourceBundle, didn't find it.");
                }
            }
            if (!(majorTokenIndex <= 0 || ((String)text).length() <= 0 || ((String)text).startsWith(".") || ((String)text).startsWith(",") || ((String)text).startsWith(";"))) {
                text = " " + (String)text;
            }
            if (text == null) continue;
            if (currIndex < minorTokens.length) {
                Integer n = currIndex;
                currIndex = currIndex + 1;
                String tag = minorTokens[n];
                String style = null;
                if (currIndex < minorTokens.length) {
                    Integer n2 = currIndex;
                    currIndex = currIndex + 1;
                    String styleKey = minorTokens[n2];
                    if (!styleMap.containsKey(styleKey)) {
                        throw new IllegalArgumentException("Expected key [" + styleKey + "] in styleMap, didn't find it.");
                    }
                    style = styleMap.get(styleKey);
                }
                CompositeTextFactory.appendTextWithTagAndStyle(parentNode, (String)text, tag, style);
                continue;
            }
            TextFactory.appendSimpleTextNode(parentNode, (String)text);
        }
    }

    public static void appendTextWithTagAndStyle(Node parentNode, String text, String tag, String style) {
        if ("span".equals(tag)) {
            TextSpanElement span = ((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextSpanElement.class);
            if (style != null) {
                span.setTextStyleNameAttribute(style);
            }
            if (text.length() > 0) {
                TextFactory.appendSimpleTextNode(span, text);
            }
            parentNode.appendChild(span);
        } else if ("tab".equals(tag)) {
            TextTabElement tab = ((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextTabElement.class);
            if (text.length() > 0) {
                TextFactory.appendSimpleTextNode(tab, text);
            }
            parentNode.appendChild(tab);
        } else if ("line-break".equals(tag)) {
            TextLineBreakElement lineBreak = ((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextLineBreakElement.class);
            if (text.length() > 0) {
                TextFactory.appendSimpleTextNode(lineBreak, text);
            }
            parentNode.appendChild(lineBreak);
        }
    }
}

