/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.table;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.clazzes.util.datetime.UtcTimestamp;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdsHelper {
    public static boolean isDateCell(TableTableCellElement cell) {
        String type = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
        if (type == null || type.trim().length() == 0 || !type.equals("date")) {
            return false;
        }
        String dateAsString = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "date-value");
        return dateAsString != null && dateAsString.trim().length() != 0;
    }

    public static Long getUtcMillis(TableTableCellElement cell, TimeZone timeZone) throws ParseException {
        String dateAsString = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "date-value");
        UtcTimestamp utcTimestamp = new UtcTimestamp(dateAsString, timeZone);
        return utcTimestamp.getUtcMillis();
    }

    public static boolean isStringCell(TableTableCellElement cell) {
        String type = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
        return type != null && type.equals("string");
    }

    public static String getStringValue(TableTableCellElement cell) {
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        return textProcessor.getText(cell);
    }

    public static boolean isFloatCell(TableTableCellElement cell) {
        String type = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
        return type != null && type.equals("float");
    }

    public static String getOfficeValue(TableTableCellElement cell) {
        return cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
    }

    public static int getNumberOfRowsRepeated(TableTableRowElement cell) {
        String rowsRepeated = cell.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated");
        if (rowsRepeated == null || "".equals(rowsRepeated)) {
            return 1;
        }
        try {
            return Integer.parseInt(rowsRepeated);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static int getNumberOfColumnsRepeated(TableTableCellElement cell) {
        String columnsRepeated = cell.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
        if (columnsRepeated == null || "".equals(columnsRepeated)) {
            return 1;
        }
        try {
            return Integer.parseInt(columnsRepeated);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static Double getFloatValue(TableTableCellElement cell) {
        String value = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isEmptyCell(TableTableCellElement cell) {
        String type = cell.getAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
        if (type == null || type.trim().length() == 0) {
            return true;
        }
        if (OdsHelper.isStringCell(cell)) {
            String text = OdsHelper.getStringValue(cell);
            return text == null || text.trim().length() == 0;
        }
        return false;
    }

    public static List<List<TableTableCellElement>> getTableData(TableTableElement tableElement) {
        int n;
        int n2;
        ArrayList<List<TableTableCellElement>> data = new ArrayList<List<TableTableCellElement>>();
        ArrayList<Integer> rowsRepeatedCounts = new ArrayList<Integer>();
        NodeList rowNodes = tableElement.getChildNodes();
        for (n2 = 0; n2 < rowNodes.getLength(); ++n2) {
            Node rowNode = rowNodes.item(n2);
            if (!(rowNode instanceof TableTableRowElement)) continue;
            ArrayList<TableTableCellElement> currCells = new ArrayList<TableTableCellElement>();
            NodeList cellNodes = rowNode.getChildNodes();
            for (int z = 0; z < cellNodes.getLength(); ++z) {
                Node cellNode = cellNodes.item(z);
                if (!(cellNode instanceof TableTableCellElement)) continue;
                currCells.add((TableTableCellElement)cellNode);
            }
            rowsRepeatedCounts.add(OdsHelper.getNumberOfRowsRepeated((TableTableRowElement)rowNode));
            data.add(currCells);
        }
        for (n2 = 0; n2 < data.size(); ++n2) {
            List line = (List)data.get(n2);
            boolean alreadyNonEmptyCellFound = false;
            for (int z = line.size() - 1; z >= 0; --z) {
                TableTableCellElement cell = (TableTableCellElement)line.get(z);
                int columnsRepeated = OdsHelper.getNumberOfColumnsRepeated(cell);
                if (!(alreadyNonEmptyCellFound |= !OdsHelper.isEmptyCell(cell))) continue;
                for (int i = 1; i < columnsRepeated; ++i) {
                    line.add(z, cell);
                }
            }
        }
        boolean onlyEmptyLinesSoFar = true;
        for (n = data.size() - 1; n >= 0; --n) {
            List lineCells = (List)data.get(n);
            for (int z = lineCells.size() - 1; z >= 0 && OdsHelper.isEmptyCell((TableTableCellElement)lineCells.get(z)); --z) {
                lineCells.remove(z);
            }
            if (lineCells.size() == 0 && onlyEmptyLinesSoFar) {
                data.remove(n);
                continue;
            }
            onlyEmptyLinesSoFar = false;
        }
        for (n = data.size() - 1; n >= 0; --n) {
            int rowsRepeated = (Integer)rowsRepeatedCounts.get(n);
            for (int z = 1; z < rowsRepeated; ++z) {
                data.add(n, (List)data.get(n));
            }
        }
        return data;
    }
}

