/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.table;

import java.text.Collator;
import java.util.List;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FancyOdfTableColumn<T> {
    private boolean headerColumn;
    private String name;
    private String caption;
    private static final Logger log = LoggerFactory.getLogger(FancyOdfTableColumn.class);

    public FancyOdfTableColumn(String name, String caption) {
        this.headerColumn = false;
        this.name = name;
        this.caption = caption;
    }

    public FancyOdfTableColumn(boolean headerColumn, String name, String caption) {
        this.headerColumn = headerColumn;
        this.name = name;
        this.caption = caption;
    }

    public boolean isHeaderColumn() {
        return this.headerColumn;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public abstract void appendCell(TableTableRowElement var1, T var2);

    public abstract int compare(T var1, T var2, boolean var3);

    public boolean filter(T data, String filter) {
        return true;
    }

    public static int defaultStringCompare(Collator collator, String s1, String s2, boolean descending) {
        if (descending) {
            return -FancyOdfTableColumn.defaultStringCompare(collator, s1, s2, false);
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return collator.compare(s1, s2);
    }

    public static int defaultStringCompare(Collator collator, String[] listOne, String[] listTwo, boolean descending) {
        Object s1 = "";
        Object s2 = "";
        for (String l1 : listOne) {
            s1 = (String)s1 + l1 + ";";
        }
        for (String l2 : listTwo) {
            s2 = (String)s2 + l2 + ";";
        }
        return FancyOdfTableColumn.defaultStringCompare(collator, (String)s1, (String)s2, descending);
    }

    public static int defaultStringCompare(Collator collator, List<String> listOne, List<String> listTwo, boolean descending) {
        Object s1 = "";
        Object s2 = "";
        for (String l1 : listOne) {
            s1 = (String)s1 + l1 + ";";
        }
        for (String l2 : listTwo) {
            s2 = (String)s2 + l2 + ";";
        }
        return FancyOdfTableColumn.defaultStringCompare(collator, (String)s1, (String)s2, descending);
    }

    public static int defaultLongCompare(Collator collator, Long l1, Long l2, boolean descending) {
        long diff;
        if (l1 == null) {
            return 1;
        }
        if (l2 == null) {
            return -1;
        }
        long l = diff = descending ? -(l1 - l2) : l1 - l2;
        if (diff > 0L) {
            return 1;
        }
        if (diff == 0L) {
            return 0;
        }
        return -1;
    }
}

