/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class FancyOdfTable<T> {
    private Styles contentAutomaticStyles;
    private String tableStyle;
    private String headerCellStyle;
    private String headerTextStyle;
    private String dataCellStyle;
    private String dataTextStyle;
    private String dataRowStyle;
    private String tableName;
    private String filter;
    private Double width;
    private Map<String, Double> relativeColumnWidths;
    private Map<String, Double> absoluteColumnWidths;
    private List<FancyOdfTableColumn<T>> columns;
    private boolean renderHeaderLine = true;
    private static final Logger log = LoggerFactory.getLogger(FancyOdfTable.class);
    private static final double EPSILON = 1.0E-7;

    public void setTableStyle(String tableStyle) {
        this.tableStyle = tableStyle;
    }

    public FancyOdfTable(String tableName, List<FancyOdfTableColumn<T>> columns) {
        this.contentAutomaticStyles = null;
        this.headerCellStyle = null;
        this.headerTextStyle = null;
        this.dataCellStyle = null;
        this.dataTextStyle = null;
        this.width = null;
        this.relativeColumnWidths = null;
        this.tableName = tableName;
        this.columns = columns;
    }

    public FancyOdfTable(Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataTextStyle, Double width, Map<String, Double> relativeColumnWidths, List<FancyOdfTableColumn<T>> columns) {
        this.contentAutomaticStyles = contentAutomaticStyles;
        this.headerCellStyle = headerCellStyle;
        this.headerTextStyle = headerTextStyle;
        this.dataCellStyle = dataCellStyle;
        this.dataTextStyle = dataTextStyle;
        this.width = width;
        this.relativeColumnWidths = relativeColumnWidths;
        this.tableName = null;
        this.columns = columns;
    }

    public void setDataRowStyle(String dataRowStyle) {
        this.dataRowStyle = dataRowStyle;
    }

    public void setAbsoluteColumnWidths(Map<String, Double> absoluteColumnWidths) {
        this.absoluteColumnWidths = absoluteColumnWidths;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setRenderHeaderLine(boolean renderHeaderLine) {
        this.renderHeaderLine = renderHeaderLine;
    }

    public void render(Node parentNode, List<T> data, List<ColumnSortSpec> columnSortSpecs) {
        this.render(parentNode, data, columnSortSpecs, false);
    }

    public void render(Node parentNode, List<T> data, List<ColumnSortSpec> columnSortSpecs, boolean checkInterrupts) {
        if (this.columns.isEmpty()) {
            return;
        }
        TableTableElement tableElement = ((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TableTableElement.class);
        parentNode.appendChild(tableElement);
        this.renderIntoTableElement(tableElement, data, columnSortSpecs, checkInterrupts);
    }

    public void renderIntoTableElement(TableTableElement tableElement, List<T> data, List<ColumnSortSpec> columnSortSpecs) {
        this.renderIntoTableElement(tableElement, data, columnSortSpecs, false);
    }

    /*
     * WARNING - void declaration
     */
    public void renderIntoTableElement(TableTableElement tableElement, List<T> data, List<ColumnSortSpec> columnSortSpecs, boolean checkInterrupts) {
        if (this.tableName != null) {
            tableElement.setTableNameAttribute(this.tableName);
        }
        if (this.tableStyle != null) {
            tableElement.setTableStyleNameAttribute(this.tableStyle);
        }
        if (this.absoluteColumnWidths == null) {
            this.absoluteColumnWidths = new HashMap<String, Double>();
            if (this.width != null && this.relativeColumnWidths != null) {
                double relativeColumnWidthSum = 0.0;
                for (Double d : this.relativeColumnWidths.values()) {
                    relativeColumnWidthSum += d.doubleValue();
                }
                for (String string : this.relativeColumnWidths.keySet()) {
                    double d = this.relativeColumnWidths.get(string) / relativeColumnWidthSum * this.width;
                    this.absoluteColumnWidths.put(string, d);
                }
                ArrayList<FancyOdfTableColumn<T>> arrayList = new ArrayList<FancyOdfTableColumn<T>>();
                for (FancyOdfTableColumn<T> fancyOdfTableColumn : this.columns) {
                    String name = fancyOdfTableColumn.getName();
                    if (!this.absoluteColumnWidths.containsKey(name) || !(this.absoluteColumnWidths.get(name) > 1.0E-7)) continue;
                    arrayList.add(fancyOdfTableColumn);
                }
                this.columns = arrayList;
            }
        }
        ArrayList<FancyOdfTableColumn<T>> headerColumns = new ArrayList<FancyOdfTableColumn<T>>();
        for (FancyOdfTableColumn<T> fancyOdfTableColumn : this.columns) {
            if (!fancyOdfTableColumn.isHeaderColumn()) continue;
            headerColumns.add(fancyOdfTableColumn);
        }
        if (headerColumns.size() > 0) {
            TableTableHeaderColumnsElement headerColumnsElement = tableElement.newTableTableHeaderColumnsElement();
            for (FancyOdfTableColumn fancyOdfTableColumn : headerColumns) {
                Double d = this.absoluteColumnWidths.get(fancyOdfTableColumn.getName());
                if (d != null) {
                    String formattedWidth = String.format(Locale.ENGLISH, "%.3f", d);
                    log.info("Column [" + fancyOdfTableColumn.getName() + "] has width [" + formattedWidth + "]");
                    String tableColumnStyle = this.contentAutomaticStyles.getTableColumnStyle(this.contentAutomaticStyles.constructTableColumnPropertiesWithAbsoluteWidth(formattedWidth + "cm"));
                    TableTableColumnElement columnElement = headerColumnsElement.newTableTableColumnElement();
                    columnElement.setStyleName(tableColumnStyle);
                    continue;
                }
                headerColumnsElement.newTableTableColumnElement();
            }
        }
        for (FancyOdfTableColumn fancyOdfTableColumn : this.columns) {
            Double d = this.absoluteColumnWidths.get(fancyOdfTableColumn.getName());
            log.info("Column [" + fancyOdfTableColumn.getName() + "] has width [" + d + "]");
            if (d != null) {
                String string = String.format(Locale.ENGLISH, "%.3f", d);
                TableFactory.appendColumnWithAbsoluteSize(this.contentAutomaticStyles, tableElement, string + "cm");
                continue;
            }
            TableFactory.appendColumnWithNoSize(tableElement);
        }
        HashMap<String, FancyOdfTableColumn<T>> columnNameToColumn = new HashMap<String, FancyOdfTableColumn<T>>();
        for (FancyOdfTableColumn<T> fancyOdfTableColumn : this.columns) {
            columnNameToColumn.put(fancyOdfTableColumn.getName(), fancyOdfTableColumn);
        }
        if (this.renderHeaderLine) {
            TableTableHeaderRowsElement tableTableHeaderRowsElement = tableElement.newTableTableHeaderRowsElement();
            TableTableRowElement tableTableRowElement = tableTableHeaderRowsElement.newTableTableRowElement();
            for (FancyOdfTableColumn<T> column : this.columns) {
                TableFactory.appendCell(this.headerCellStyle, this.headerTextStyle, tableTableRowElement, column.getCaption());
            }
        }
        if (columnSortSpecs != null) {
            void var7_20;
            int n = columnSortSpecs.size() - 1;
            while (var7_20 >= 0) {
                boolean descending;
                ColumnSortSpec columnSortSpec = columnSortSpecs.get((int)var7_20);
                final FancyOdfTableColumn fancyOdfTableColumn = (FancyOdfTableColumn)columnNameToColumn.get(columnSortSpec.getProperty());
                boolean bl = descending = columnSortSpec.getDescending() != null ? columnSortSpec.getDescending() : false;
                if (fancyOdfTableColumn != null) {
                    Collections.sort(data, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            return fancyOdfTableColumn.compare(o1, o2, descending);
                        }
                    });
                }
                --var7_20;
            }
        }
        for (T t2 : data) {
            void var9_47;
            if (this.filter != null) {
                boolean bl = false;
                for (FancyOdfTableColumn<T> column : this.columns) {
                    var9_45 |= column.filter(t2, this.filter);
                }
            } else {
                boolean bl = true;
            }
            if (var9_47 != false) {
                TableTableRowElement rowElement = TableFactory.appendRow(tableElement, this.dataRowStyle);
                for (FancyOdfTableColumn<T> column : this.columns) {
                    column.appendCell(rowElement, t2);
                }
            }
            if (!checkInterrupts || !Thread.currentThread().isInterrupted()) continue;
            throw new RuntimeException("Table generation was interrupted.");
        }
    }
}

