/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.style;

import org.clazzes.util.lang.Pair;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopsElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;

public class ParagraphStyleFactory {
    public static void setMarginAttributes(StyleParagraphPropertiesElement paragraphProperties, String marginLeft, String marginRight, String marginTop, String marginBottom) {
        if (marginLeft != null) {
            paragraphProperties.setFoMarginLeftAttribute(marginLeft);
        }
        if (marginRight != null) {
            paragraphProperties.setFoMarginRightAttribute(marginRight);
        }
        if (marginTop != null) {
            paragraphProperties.setFoMarginTopAttribute(marginTop);
        }
        if (marginBottom != null) {
            paragraphProperties.setFoMarginBottomAttribute(marginBottom);
        }
    }

    public static void setLineAttributes(StyleParagraphPropertiesElement paragraphProperties, Boolean numberLines, Integer lineNumber) {
        if (numberLines != null) {
            paragraphProperties.setTextNumberLinesAttribute(numberLines);
        }
        if (lineNumber != null) {
            paragraphProperties.setTextLineNumberAttribute(lineNumber);
        }
    }

    public static void addTabStops(StyleParagraphPropertiesElement paragraphProperties, String ... tabStops) {
        StyleTabStopsElement tabStopsElement = ((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopsElement.class);
        for (String tabStop : tabStops) {
            StyleTabStopElement tabStopElement = ((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopElement.class);
            tabStopElement.setStylePositionAttribute(tabStop);
            tabStopsElement.appendChild(tabStopElement);
        }
        paragraphProperties.appendChild(tabStopsElement);
    }

    @SafeVarargs
    public static void addTabStops(StyleParagraphPropertiesElement paragraphProperties, Pair<String, String> ... tabStops) {
        StyleTabStopsElement tabStopsElement = ((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopsElement.class);
        for (Pair<String, String> tabStop : tabStops) {
            StyleTabStopElement tabStopElement = ((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopElement.class);
            tabStopElement.setStylePositionAttribute((String)tabStop.getFirst());
            tabStopElement.setStyleTypeAttribute((String)tabStop.getSecond());
            tabStopsElement.appendChild(tabStopElement);
        }
        paragraphProperties.appendChild(tabStopsElement);
    }
}

