/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.style;

import org.odftoolkit.odfdom.dom.element.style.StyleColumnsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;

public class GraphicStyleFactory {
    public static void setMarginRelatedAttributes(StyleGraphicPropertiesElement properties, String margin, String padding, String border) {
        GraphicStyleFactory.setMarginAttributes(properties, margin);
        GraphicStyleFactory.setPaddingAttributes(properties, padding);
        GraphicStyleFactory.setBorderAttributes(properties, border);
    }

    public static void setMarginAttributes(StyleGraphicPropertiesElement properties, String margin) {
        if (margin != null) {
            properties.setFoMarginLeftAttribute(margin);
            properties.setFoMarginRightAttribute(margin);
            properties.setFoMarginTopAttribute(margin);
            properties.setFoMarginBottomAttribute(margin);
        }
    }

    public static void setPaddingAttributes(StyleGraphicPropertiesElement properties, String padding) {
        if (padding != null) {
            properties.setFoPaddingLeftAttribute(padding);
            properties.setFoPaddingRightAttribute(padding);
            properties.setFoPaddingTopAttribute(padding);
            properties.setFoPaddingBottomAttribute(padding);
        }
    }

    public static void setBorderAttributes(StyleGraphicPropertiesElement properties, String border) {
        if (border != null) {
            properties.setFoBorderLeftAttribute(border);
            properties.setFoBorderRightAttribute(border);
            properties.setFoBorderTopAttribute(border);
            properties.setFoBorderBottomAttribute(border);
        }
    }

    public static void setSvgPositionAttributes(StyleGraphicPropertiesElement properties, String x, String y) {
        if (x != null) {
            properties.setSvgXAttribute(x);
        }
        if (y != null) {
            properties.setSvgYAttribute(y);
        }
    }

    public static void setPositionAttributes(StyleGraphicPropertiesElement properties, String verticalPos, String verticalRel, String horizontalPos, String horizontalRel) {
        if (verticalPos != null) {
            properties.setStyleVerticalPosAttribute(verticalPos);
        }
        if (verticalRel != null) {
            properties.setStyleVerticalRelAttribute(verticalRel);
        }
        if (horizontalPos != null) {
            properties.setStyleHorizontalPosAttribute(horizontalPos);
        }
        if (horizontalRel != null) {
            properties.setStyleHorizontalRelAttribute(horizontalRel);
        }
    }

    public static void setBackgroundColorAttributes(StyleGraphicPropertiesElement properties, String backgroundColor, String backgroundTransparency) {
        if (backgroundColor != null) {
            properties.setFoBackgroundColorAttribute(backgroundColor);
        }
        if (backgroundTransparency != null) {
            properties.setStyleBackgroundTransparencyAttribute(backgroundTransparency);
        }
    }

    public static void setShadowAttributes(StyleGraphicPropertiesElement properties, String shadow, String shadowOpacity) {
        if (shadow != null) {
            properties.setStyleShadowAttribute(shadow);
        }
        if (shadowOpacity != null) {
            properties.setDrawShadowOpacityAttribute(shadowOpacity);
        }
    }

    public static void setWrapRelatedAttributes(StyleGraphicPropertiesElement properties, String wrap, Integer wrappedParagraphs, Boolean wrapContour) {
        if (wrap != null) {
            properties.setStyleWrapAttribute(wrap);
        }
        if (wrappedParagraphs != null) {
            properties.setStyleNumberWrappedParagraphsAttribute(wrappedParagraphs);
        }
        if (wrapContour != null) {
            properties.setStyleWrapContourAttribute(wrapContour);
        }
    }

    public static void appendColumnsAttribute(StyleGraphicPropertiesElement properties, Integer columnCount, String columnGap) {
        StyleColumnsElement columnsElement = ((OdfFileDom)properties.getOwnerDocument()).newOdfElement(StyleColumnsElement.class);
        if (columnCount != null) {
            columnsElement.setFoColumnCountAttribute(columnCount);
        }
        if (columnGap != null) {
            columnsElement.setFoColumnGapAttribute(columnGap);
        }
        properties.appendChild(columnsElement);
    }

    public static void setColorAttributes(StyleGraphicPropertiesElement properties, String colorMode, String red, String green, String blue, String gamma, Boolean colorInversion, String luminance, String contrast, String imageOpacity) {
        if (colorMode != null) {
            properties.setDrawColorModeAttribute(colorMode);
        }
        if (red != null) {
            properties.setDrawRedAttribute(red);
        }
        if (blue != null) {
            properties.setDrawBlueAttribute(blue);
        }
        if (green != null) {
            properties.setDrawGreenAttribute(green);
        }
        if (gamma != null) {
            properties.setDrawGammaAttribute(gamma);
        }
        if (colorInversion != null) {
            properties.setDrawColorInversionAttribute(colorInversion);
        }
        if (luminance != null) {
            properties.setDrawLuminanceAttribute(luminance);
        }
        if (contrast != null) {
            properties.setDrawContrastAttribute(contrast);
        }
        if (imageOpacity != null) {
            properties.setDrawImageOpacityAttribute(imageOpacity);
        }
    }
}

