/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.style;

import java.util.List;
import org.clazzes.odf.util.core.NodeHelper;
import org.clazzes.odf.util.style.StyleRepository;
import org.clazzes.odf.util.style.Styles;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderStyleElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;

public class AutomaticStyles
extends Styles {
    private OdfOfficeAutomaticStyles automaticStyles;

    public AutomaticStyles(StyleRepository styleRepository, OdfOfficeAutomaticStyles automaticStyles, String stylePrefix) {
        super(styleRepository, automaticStyles, stylePrefix);
        this.automaticStyles = automaticStyles;
    }

    public void setHeaderDimensions(String pageLayoutName, String height, String marginLeft, String marginRight, String marginBottom) {
        StyleHeaderFooterPropertiesElement headerProperties = this.getOrCreateHeaderProperties(pageLayoutName);
        headerProperties.setSvgHeightAttribute(height);
        headerProperties.setFoMarginLeftAttribute(marginLeft);
        headerProperties.setFoMarginRightAttribute(marginRight);
        headerProperties.setFoMarginBottomAttribute(marginBottom);
        headerProperties.setFoBackgroundColorAttribute("transparent");
        headerProperties.setStyleDynamicSpacingAttribute(false);
    }

    public void setFooterDimensions(String pageLayoutName, String minHeight, String marginLeft, String marginRight, String marginTop) {
        StyleHeaderFooterPropertiesElement footerProperties = this.getOrCreateFooterProperties(pageLayoutName);
        footerProperties.setFoMinHeightAttribute(minHeight);
        footerProperties.setFoMarginLeftAttribute(marginLeft);
        footerProperties.setFoMarginRightAttribute(marginRight);
        footerProperties.setFoMarginTopAttribute(marginTop);
        footerProperties.setFoBackgroundColorAttribute("transparent");
        footerProperties.setStyleDynamicSpacingAttribute(false);
    }

    private StyleHeaderFooterPropertiesElement getOrCreateHeaderProperties(String pageLayoutName) {
        StyleHeaderStyleElement headerStyleElement = this.getOrCreateHeaderStyleElement(pageLayoutName);
        StyleHeaderFooterPropertiesElement headerFooterProperties = this.getOrCreateHeaderProperties(headerStyleElement);
        return headerFooterProperties;
    }

    private StyleHeaderFooterPropertiesElement getOrCreateFooterProperties(String pageLayoutName) {
        StyleFooterStyleElement footerStyleElement = this.getOrCreateFooterStyleElement(pageLayoutName);
        StyleHeaderFooterPropertiesElement headerFooterProperties = this.getOrCreateFooterProperties(footerStyleElement);
        return headerFooterProperties;
    }

    private StyleHeaderStyleElement getOrCreateHeaderStyleElement(String pageLayoutName) {
        OdfStylePageLayout pageLayout = this.automaticStyles.getPageLayout(pageLayoutName);
        List<StyleHeaderStyleElement> headerStyleElements = NodeHelper.getChildNodes(pageLayout, StyleHeaderStyleElement.class);
        if (headerStyleElements.size() == 0) {
            return pageLayout.newStyleHeaderStyleElement();
        }
        return headerStyleElements.get(0);
    }

    private StyleFooterStyleElement getOrCreateFooterStyleElement(String pageLayoutName) {
        OdfStylePageLayout pageLayout = this.automaticStyles.getPageLayout(pageLayoutName);
        List<StyleFooterStyleElement> footerStyleElements = NodeHelper.getChildNodes(pageLayout, StyleFooterStyleElement.class);
        if (footerStyleElements.size() == 0) {
            return pageLayout.newStyleFooterStyleElement();
        }
        return footerStyleElements.get(0);
    }

    private StyleHeaderFooterPropertiesElement getOrCreateHeaderProperties(StyleHeaderStyleElement headerStyleElement) {
        List<StyleHeaderFooterPropertiesElement> headerFooterElements = NodeHelper.getChildNodes(headerStyleElement, StyleHeaderFooterPropertiesElement.class);
        if (headerFooterElements.size() == 0) {
            return headerStyleElement.newStyleHeaderFooterPropertiesElement();
        }
        return headerFooterElements.get(0);
    }

    private StyleHeaderFooterPropertiesElement getOrCreateFooterProperties(StyleFooterStyleElement footerStyleElement) {
        List<StyleHeaderFooterPropertiesElement> headerFooterElements = NodeHelper.getChildNodes(footerStyleElement, StyleHeaderFooterPropertiesElement.class);
        if (headerFooterElements.size() == 0) {
            return footerStyleElement.newStyleHeaderFooterPropertiesElement();
        }
        return headerFooterElements.get(0);
    }
}

