/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.imp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.odf.util.table.OdsHelper;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsImporter {
    private static final Logger log = LoggerFactory.getLogger(XlsImporter.class);

    public static List<List<String>> getCellContents(File file) {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        List<List<TableTableCellElement>> cells = XlsImporter.getCells(file);
        for (List<TableTableCellElement> row : cells) {
            ArrayList<String> rowContents = new ArrayList<String>();
            for (TableTableCellElement cell : row) {
                String value = XlsImporter.getCellString(cell);
                rowContents.add(value != null ? value.trim() : null);
            }
            contents.add(rowContents);
        }
        return contents;
    }

    public static List<List<TableTableCellElement>> getCells(File file) {
        OdfSpreadsheetDocument document;
        try {
            document = OdfSpreadsheetDocument.loadDocument(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            List<OdfTable> tables = document.getTableList();
            if (tables.size() == 0) {
                throw new IllegalArgumentException("Document needs to contain at least one table.");
            }
            OdfTable table = tables.get(0);
            TableTableElement tableElement = table.getOdfElement();
            return OdsHelper.getTableData(tableElement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getCellString(TableTableCellElement cell) {
        String value = OdsHelper.getStringValue(cell);
        return value;
    }
}

