/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.html;

import java.util.List;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.text.TextFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdfFromHtmlConverter {
    private static final Logger log = LoggerFactory.getLogger(OdfFromHtmlConverter.class);

    public static org.w3c.dom.Node convert(org.w3c.dom.Node parentNode, String html, String baseTextStyle, Styles styles) {
        Document document = Jsoup.parse(html);
        Element body = document.body();
        TextPElement odfBaseNode = TextFactory.constructTextNode(parentNode, "", baseTextStyle);
        boolean allSupported = OdfFromHtmlConverter.constructChildNodes(odfBaseNode, body.childNodes(), baseTextStyle, styles);
        if (!allSupported) {
            parentNode.removeChild(odfBaseNode);
            TextFactory.constructTextNode(parentNode, html, baseTextStyle);
        }
        return odfBaseNode;
    }

    private static boolean constructChildNodes(org.w3c.dom.Node node, List<Node> jsoupNodes, String baseTextStyle, Styles styles) {
        boolean allSupported = true;
        for (Node jsoupNode : jsoupNodes) {
            String style;
            if (jsoupNode instanceof TextNode) {
                TextNode textNode = (TextNode)jsoupNode;
                TextFactory.constructTextSpan(node, textNode.getWholeText(), baseTextStyle);
                continue;
            }
            if (!(jsoupNode instanceof Element)) continue;
            Element jsoupElement = (Element)jsoupNode;
            String tag = jsoupElement.tagName();
            if ("b".equals(tag)) {
                style = styles.getTextStyle(styles.constructTextPropertiesWithFontWeight("bold"));
                allSupported &= OdfFromHtmlConverter.constructChildNodes(node, jsoupElement.childNodes(), style, styles);
                continue;
            }
            if ("u".equals(tag)) {
                style = styles.getTextStyle(styles.constructUnderlineTextProperties("solid", "auto", "font-color"));
                allSupported &= OdfFromHtmlConverter.constructChildNodes(node, jsoupElement.childNodes(), style, styles);
                continue;
            }
            log.warn("Ignored unsupported html tag [" + tag + "] while converting from html to odf, falling back to plain text output");
            allSupported = false;
        }
        return allSupported;
    }
}

