/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.file;

import java.io.File;
import org.clazzes.odf.util.file.OdfConversionHandle;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.ooo.engine.OOoFileTicket;

public class ConversionHelper {
    public static String convert(File odtFile, OOoFileConversionTicket.TargetFileType targetFileType, OOoFileEngine oooFileEngine) {
        return ConversionHelper.convert(odtFile, targetFileType, oooFileEngine, 60000L);
    }

    public static String convert(File odtFile, OOoFileConversionTicket.TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout) {
        return ConversionHelper.convert(odtFile, targetFileType, oooFileEngine, timeout, null, null);
    }

    public static String convert(File odtFile, OOoFileConversionTicket.TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout, Integer slotId, OdfConversionHandle handle) {
        if (timeout == null) {
            timeout = 60000L;
        }
        OOoFileConversionTicket conversionTicket = new OOoFileConversionTicket();
        conversionTicket.setSlotId(slotId);
        conversionTicket.setKeepOOoFile(true);
        conversionTicket.setKeepTargetFile(true);
        conversionTicket.setOooFileName(odtFile.getAbsolutePath());
        String odtFileName = odtFile.getName();
        int lastDotPosition = odtFileName.lastIndexOf(46);
        String prefix = lastDotPosition != -1 ? odtFileName.substring(0, lastDotPosition) : odtFileName;
        File parentDirectory = odtFile.getParentFile();
        String targetFileName = prefix + "." + targetFileType.toExtension();
        File targetFile = new File(parentDirectory, targetFileName);
        conversionTicket.setTargetFileName(targetFile.getAbsolutePath());
        conversionTicket.setTargetFileType(targetFileType);
        oooFileEngine.queueTicket((OOoFileTicket)conversionTicket);
        if (handle != null) {
            handle.setTicket(conversionTicket);
        }
        conversionTicket.getStatusAndWaitForCompletion(timeout.longValue());
        if (!conversionTicket.isClosedOK()) {
            throw new RuntimeException("conversionTicket failed.");
        }
        return targetFile.getAbsolutePath();
    }
}

