/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.odf.util.chart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.clazzes.odf.util.chart.ChartFactory;
import org.clazzes.odf.util.chart.OdfChartColumn;
import org.clazzes.odf.util.chart.OdfChartDataPoint;
import org.clazzes.odf.util.style.NumberStyleFactory;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.voc.StyleFamily;
import org.odftoolkit.odfdom.dom.element.chart.ChartAxisElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartChartElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartPlotAreaElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartSeriesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeChartElement;
import org.odftoolkit.odfdom.dom.element.style.StyleChartPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.w3c.dom.Node;

public class OdfChart<T extends OdfChartDataPoint> {
    private List<OdfChartColumn<T>> columns = new ArrayList<OdfChartColumn<T>>();
    private String width;
    private String height;
    private String chartClass;
    private String legendPosition;
    private String legendX;
    private String legendY;
    private String legendExpansion;
    private String plotAreaX;
    private String plotAreaY;
    private String plotAreaWidth;
    private String plotAreaHeight;
    private String coordRegionX;
    private String coordRegionY;
    private String coordRegionWidth;
    private String coordRegionHeight;
    private static final String TABLE_NAME = "local-table";

    public void addColumn(OdfChartColumn<T> chartColumn) {
        this.columns.add(chartColumn);
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setChartClass(String chartClass) {
        this.chartClass = chartClass;
    }

    public void setLegendPosition(String legendPosition) {
        this.legendPosition = legendPosition;
    }

    public void setLegendX(String legendX) {
        this.legendX = legendX;
    }

    public void setLegendY(String legendY) {
        this.legendY = legendY;
    }

    public void setLegendExpansion(String legendExpansion) {
        this.legendExpansion = legendExpansion;
    }

    public void setPlotAreaX(String plotAreaX) {
        this.plotAreaX = plotAreaX;
    }

    public void setPlotAreaY(String plotAreaY) {
        this.plotAreaY = plotAreaY;
    }

    public void setPlotAreaWidth(String plotAreaWidth) {
        this.plotAreaWidth = plotAreaWidth;
    }

    public void setPlotAreaHeight(String plotAreaHeight) {
        this.plotAreaHeight = plotAreaHeight;
    }

    public void setCoordRegionX(String coordRegionX) {
        this.coordRegionX = coordRegionX;
    }

    public void setCoordRegionY(String coordRegionY) {
        this.coordRegionY = coordRegionY;
    }

    public void setCoordRegionWidth(String coordRegionWidth) {
        this.coordRegionWidth = coordRegionWidth;
    }

    public void setCoordRegionHeight(String coordRegionHeight) {
        this.coordRegionHeight = coordRegionHeight;
    }

    public void render(Styles stylesStyles, Styles contentAutomaticStyles, Node parentNode, List<T> dataPoints) {
        String numberStyle = this.getChartNumberStyle(stylesStyles);
        String dateStyle = this.getChartDateStyle(stylesStyles);
        String chartStyle = this.getChartStyle(stylesStyles);
        String legendStyle = this.getLegendStyle(stylesStyles);
        String plotAreaStyle = this.getPlotAreaStyle(stylesStyles);
        String xAxisStyle = this.getXAxisStyle(stylesStyles, dateStyle);
        String yAxisStyle = this.getYAxisStyle(stylesStyles, numberStyle);
        String yAxisGridStyle = this.getYAxisGridStyle(stylesStyles);
        String seriesStyle = this.getChartSeriesStyle(stylesStyles, numberStyle);
        String wallStyle = this.getWallStyle(stylesStyles);
        String floorStyle = this.getFloorStyle(stylesStyles);
        OfficeChartElement officeChartElement = ChartFactory.constructOfficeChart(parentNode);
        ChartChartElement chartChartElement = ChartFactory.constructChartChart(officeChartElement, this.width, this.height, this.chartClass, chartStyle);
        ChartFactory.constructChartLegend(chartChartElement, this.legendPosition, this.legendX, this.legendY, this.legendExpansion, legendStyle);
        ChartPlotAreaElement plotAreaElement = ChartFactory.constructChartPlotArea(chartChartElement, this.plotAreaX, this.plotAreaY, this.plotAreaWidth, this.plotAreaHeight, "both", plotAreaStyle);
        ChartAxisElement xAxis = ChartFactory.constructChartAxis(plotAreaElement, "x", "primary-x", xAxisStyle);
        ChartFactory.constructChartCategories(xAxis, TABLE_NAME, this.columns.size());
        ChartAxisElement yAxis = ChartFactory.constructChartAxis(plotAreaElement, "y", "primary-y", yAxisStyle);
        ChartFactory.constructChartGrid(yAxis, "major", yAxisGridStyle);
        ChartSeriesElement chartSeriesElement = ChartFactory.constructChartSeries((Node)plotAreaElement, TABLE_NAME, this.columns.size(), "chart:circle", seriesStyle);
        for (OdfChartDataPoint dataPoint : dataPoints) {
            String dataPointStyle = dataPoint.getDataPointStyle(contentAutomaticStyles);
            ChartFactory.constructChartDataPoint(chartSeriesElement, dataPointStyle);
        }
        ChartFactory.constructChartWall(plotAreaElement, wallStyle);
        ChartFactory.constructChartFloor(plotAreaElement, floorStyle);
        this.constructDataTable(chartChartElement, stylesStyles, dataPoints);
    }

    protected String getChartNumberStyle(Styles styles) {
        return styles.getStyle(StyleFamily.NUMBER, NumberStyleFactory.constructNumberNumberStyleElement(styles), NumberStyleFactory.constructNumberNumberElement(styles, 1));
    }

    protected String getChartDateStyle(Styles styles) {
        return styles.getStyle(StyleFamily.DATE, NumberStyleFactory.constructNumberDateStyleElement(styles, "de", "AT", true), NumberStyleFactory.constructNumberDayElement(styles, "long"), NumberStyleFactory.constructNumberTextElement(styles, "."), NumberStyleFactory.constructNumberMonthElement(styles, "long"), NumberStyleFactory.constructNumberTextElement(styles, "."), NumberStyleFactory.constructNumberYearElement(styles, "long"));
    }

    protected String getChartStyle(Styles styles) {
        return styles.getChartStyle(styles.constructGraphicPropertiesWithStrokeAndFill("none", "none"));
    }

    protected String getLegendStyle(Styles styles) {
        return styles.getChartStyle(styles.constructChartPropertiesWithAutoPosition(true), styles.constructGraphicPropertiesWithStrokeAndFillAndColor("none", "#b3b3b3", "none", "#e6e6e6"), styles.constructTextPropertiesWithFontSize("10pt"));
    }

    protected String getPlotAreaStyle(Styles styles) {
        StyleChartPropertiesElement chartProperties = styles.constructChartProperties();
        chartProperties.setChartIncludeHiddenCellsAttribute(false);
        chartProperties.setChartAutoPositionAttribute(true);
        chartProperties.setChartAutoSizeAttribute(true);
        chartProperties.setChartRightAngledAxesAttribute(true);
        return styles.getChartStyle(chartProperties);
    }

    protected String getXAxisStyle(Styles styles, String dataStyleName) {
        StyleChartPropertiesElement chartProperties = styles.constructChartProperties();
        chartProperties.setChartDisplayLabelAttribute(true);
        chartProperties.setChartLogarithmicAttribute(false);
        chartProperties.setChartReverseDirectionAttribute(true);
        chartProperties.setTextLineBreakAttribute(false);
        chartProperties.setChartLinkDataStyleToSourceAttribute(true);
        chartProperties.setChartAxisPositionAttribute(0.0);
        return styles.getChartStyleWithDataStyle(dataStyleName, chartProperties, styles.constructGraphicPropertiesWithColor("#b3b3b3", null), styles.constructTextPropertiesWithFontSize("10pt"));
    }

    protected String getYAxisStyle(Styles styles, String dataStyleName) {
        StyleChartPropertiesElement chartProperties = styles.constructChartProperties();
        chartProperties.setChartDisplayLabelAttribute(true);
        chartProperties.setChartLogarithmicAttribute(false);
        chartProperties.setChartReverseDirectionAttribute(false);
        chartProperties.setTextLineBreakAttribute(false);
        chartProperties.setChartLinkDataStyleToSourceAttribute(true);
        chartProperties.setChartAxisPositionAttribute(0.0);
        return styles.getChartStyleWithDataStyle(dataStyleName, chartProperties, styles.constructGraphicPropertiesWithColor("#b3b3b3", null), styles.constructTextPropertiesWithFontSize("10pt"));
    }

    protected String getYAxisGridStyle(Styles styles) {
        return styles.getChartStyle(styles.constructGraphicPropertiesWithColor("#b3b3b3", null));
    }

    protected String getChartSeriesStyle(Styles styles, String dataStyleName) {
        StyleChartPropertiesElement chartProperties = styles.constructChartProperties();
        chartProperties.setChartLinkDataStyleToSourceAttribute(true);
        StyleGraphicPropertiesElement graphicProperties = styles.constructGraphicProperties();
        graphicProperties.setDrawStrokeAttribute("none");
        graphicProperties.setDrawFillColorAttribute("#004586");
        graphicProperties.setDr3dEdgeRoundingAttribute("5%");
        return styles.getChartStyleWithDataStyle(dataStyleName, chartProperties, graphicProperties, styles.constructTextPropertiesWithFontSize("10pt"));
    }

    protected String getDataPointStyle(Styles styles, String fillColor) {
        return styles.getChartStyle(styles.constructGraphicPropertiesWithColor(null, fillColor));
    }

    protected String getWallStyle(Styles styles) {
        return styles.getChartStyle(styles.constructGraphicPropertiesWithStrokeAndFillAndColor("solid", "#b3b3b3", "none", "#e6e6e6"));
    }

    protected String getFloorStyle(Styles styles) {
        return styles.getChartStyle(styles.constructGraphicPropertiesWithColor("#b3b3b3", "#cccccc"));
    }

    protected void constructDataTable(Node parentNode, Styles styles, List<T> data) {
        ArrayList fancyTableColumns = new ArrayList();
        Iterator<OdfChartColumn<T>> iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            OdfChartColumn<T> chartColumn;
            final OdfChartColumn<T> localChartColumn = chartColumn = iterator.next();
            fancyTableColumns.add(new FancyOdfTableColumn<T>(chartColumn.isHeaderColumn(), chartColumn.getName(), chartColumn.getLabel()){

                @Override
                public void appendCell(TableTableRowElement rowElement, T data) {
                    localChartColumn.appendDataTableCell(rowElement, data);
                }

                @Override
                public int compare(T dataOne, T dataTwo, boolean descending) {
                    return 0;
                }
            });
        }
        FancyOdfTable<T> table = new FancyOdfTable<T>(TABLE_NAME, fancyTableColumns);
        table.render(parentNode, data, null);
    }
}

