/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.jena.util.iterator.WrappedIterator;

public class FilterIterator<T>
extends WrappedIterator<T> {
    protected final Predicate<T> f;
    protected T current;
    protected boolean canRemove;
    protected boolean hasCurrent;

    public FilterIterator(Predicate<T> fl, Iterator<T> e) {
        super(e);
        this.f = fl;
    }

    @Override
    public boolean hasNext() {
        while (!this.hasCurrent && super.hasNext()) {
            this.current = super.next();
            this.hasCurrent = this.f.test(this.current);
        }
        this.canRemove = false;
        return this.hasCurrent;
    }

    @Override
    public void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException("FilterIterators do not permit calls to hasNext between calls to next and remove.");
        }
        super.remove();
    }

    @Override
    public T next() {
        if (this.hasCurrent || this.hasNext()) {
            this.canRemove = true;
            this.hasCurrent = false;
            return this.current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (this.hasCurrent) {
            action.accept(this.current);
            this.hasCurrent = false;
        }
        super.forEachRemaining((? super T e) -> {
            if (this.f.test(e)) {
                action.accept(e);
            }
        });
    }
}

