/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;

public class LogCtlLog4j2 {
    public static String log4j2setup = StrUtils.strjoinNL("## Command default log4j2 setup : log4j2 properties syntax.", "status = error", "name = JenaLoggingDft", "appender.console.type = Console", "appender.console.name = OUT", "appender.console.target = SYSTEM_OUT", "appender.console.layout.type = PatternLayout", "appender.console.layout.pattern = %d{HH:mm:ss} %-5p %-15c{1} :: %m%n", "#appender.console.layout.pattern = [%d{yyyy-MM-dd HH:mm:ss}] %-5p %-15c{1} :: %m%n", "rootLogger.level                  = INFO", "rootLogger.appenderRef.stdout.ref = OUT", "logger.jena.name  = org.apache.jena", "logger.jena.level = INFO", "logger.arq-exec.name  = org.apache.jena.arq.exec", "logger.arq-exec.level = INFO", "logger.riot.name  = org.apache.jena.riot", "logger.riot.level = INFO", "logger.jetty.name  = org.eclipse.jetty", "logger.jetty.level = WARN");

    public static void resetLogging(String configString) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(StrUtils.asUTF8bytes(configString));){
            LogCtlLog4j2.resetLogging(inputStream, ".properties");
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void resetLogging(InputStream inputStream, String syntaxHint) throws IOException {
        ConfigurationSource source = new ConfigurationSource(inputStream);
        ConfigurationFactory factory = syntaxHint.endsWith(".properties") ? new PropertiesConfigurationFactory() : ConfigurationFactory.getInstance();
        Configuration configuration = factory.getConfiguration(null, source);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.setConfiguration(configuration);
    }

    static void setLoggerlevel(String logger, Level level) {
        try {
            if (!logger.equals("")) {
                Configurator.setLevel((String)logger, (Level)level);
            } else {
                Configurator.setRootLevel((Level)level);
            }
        }
        catch (NoClassDefFoundError ex) {
            Log.warnOnce(LogCtl.class, "Log4j2 Configurator not found", LogCtl.class);
        }
    }
}

