/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.rootdev.javardfa.Parser;
import net.rootdev.javardfa.ParserFactory;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import net.rootdev.javardfa.query.QueryCollector;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class QueryUtilities {
    static final Logger log = LoggerFactory.getLogger(QueryUtilities.class);
    public static final QuerySolution NoResult = new QuerySolutionMap();

    public static Map<String, Query> makeQueries(ParserFactory.Format format, String source) throws SAXException, IOException {
        QueryCollector qc = new QueryCollector();
        XMLReader reader = ParserFactory.createReaderForFormat((StatementSink)qc, format, new Setting[0]);
        ((Parser)reader.getContentHandler()).enable(Setting.FormMode);
        if (source.matches("file:/[^/][^/].*")) {
            source = source.replaceFirst("file:/", "file:///");
        }
        reader.parse(source);
        return qc.getQueries();
    }

    public static QuerySolution extractBinding(Model model, Query query) {
        QuerySolution toReturn;
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet res = qe.execSelect();
        QuerySolution querySolution = toReturn = res.hasNext() ? res.next() : NoResult;
        if (res.hasNext()) {
            log.warn("More than one available binding");
        }
        qe.close();
        return toReturn;
    }

    public static Model bind(Query query, Map<String, String> bindings) {
        List<Triple> triples = QueryUtilities.pullTriples(query);
        LinkedList boundTriples = new LinkedList();
        Model model = ModelFactory.createDefaultModel();
        for (Triple t2 : triples) {
            Node s2 = QueryUtilities.bind(t2.getSubject(), bindings);
            Node p = QueryUtilities.bind(t2.getPredicate(), bindings);
            Node o = QueryUtilities.bind(t2.getObject(), bindings);
            Triple nt = Triple.create(s2, p, o);
            model.add(model.asStatement(nt));
        }
        return model;
    }

    private static List<Triple> pullTriples(Query query) {
        LinkedList<Triple> triples = new LinkedList<Triple>();
        ElementWalker.walk((Element)query.getQueryPattern(), (ElementVisitor)new TripleCollector(triples));
        return triples;
    }

    private static Node bind(Node object, Map<String, String> bindings) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static class TripleCollector
    extends ElementVisitorBase {
        private final List<Triple> triples;

        private TripleCollector(List<Triple> triples) {
            this.triples = triples;
        }

        public void visit(ElementTriplesBlock el) {
            this.triples.addAll(el.getPattern().getList());
        }
    }
}

