/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 08.08.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.table;

import java.text.Collator;

import org.clazzes.util.aop.ThreadLocalManager;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SimpleOdfStringColumn<T> extends FancyOdfTableColumn<T> {
    
    private String dataCellStyle;
    private String dataTextStyle;
    private Collator collator;
    
    public SimpleOdfStringColumn(String name, String caption, String dataCellStyle, String dataTextStyle) {
        super(name, caption);
        this.dataCellStyle = dataCellStyle;
        this.dataTextStyle = dataTextStyle;
    }

    protected abstract String getString(T data);

    public void appendCell(TableTableRowElement rowElement, T data) {
        TableTableCellElement cellElement = TableFactory.appendCell(dataCellStyle, dataTextStyle, rowElement, this.getString(data));
        /* Trying to make it recalculate the row height.  Without success so far.
        NodeList nodeList = cellElement.getChildNodes();
        for (int n = 0; n < nodeList.getLength(); n++) {
            Node node = nodeList.item(n);
            if (node instanceof TextPElement) {
                TextPElement pElement = (TextPElement)node;
                pElement.setTextContent(pElement.getTextContent());
            }
        }
        */
    }
    public int compare(T dataOne, T dataTwo, boolean descending) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        return FancyOdfTableColumn.defaultStringCompare(collator, this.getString(dataOne), this.getString(dataTwo), descending);
    }    
}
