/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 12.04.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.table;

import java.util.ArrayList;
import java.util.List;

import org.clazzes.util.lang.Pair;

public class ColumnSortSpec {
    private Boolean descending;
    private String property;
    
    public ColumnSortSpec(String property, Boolean descending) {
        this.property = property;
        this.descending = descending;
    }
    
    public Boolean getDescending() {
        return this.descending;
    }
    public void setDescending(Boolean descending) {
        this.descending = descending;
    }
    public String getProperty() {
        return this.property;
    }
    public void setProperty(String property) {
        this.property = property;
    }    
    
    public static List<ColumnSortSpec> getFromClient(List<Pair<String, Boolean>> clientSpecs) {
        List<ColumnSortSpec> sortSpecs = new ArrayList<ColumnSortSpec>();
        for (Pair<String, Boolean> clientSpec : clientSpecs) {
            sortSpecs.add(new ColumnSortSpec(clientSpec.getFirst(), clientSpec.getSecond()));
        }        
        return sortSpecs;
    }
}
