/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 06.12.2016
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.style;

import org.clazzes.odf.util.core.OdfContext;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;

public class TextStyleFactory {

    
    public static StyleTextPropertiesElement constructFontTextProperties(Styles context, 
                                                                         String fontName, String fontFamily, String fontSize,
                                                                         String fontStyleName, String fontFamilyGeneric, String fontPitch) {
        StyleTextPropertiesElement textProperties = context.constructTextProperties();
        
        textProperties.setStyleFontNameAttribute(fontName);
        textProperties.setFoFontFamilyAttribute(fontFamily);
        textProperties.setFoFontSizeAttribute(fontSize);
        textProperties.setFoFontStyleAttribute(fontStyleName);
        textProperties.setStyleFontFamilyGenericAttribute(fontFamilyGeneric);
        textProperties.setStyleFontPitchAttribute(fontPitch);
        
        return textProperties;
    }

    public static void setFontNameProperties(StyleTextPropertiesElement properties, String fontName) {
        TextStyleFactory.setFontNameProperties(properties,  fontName, fontName, fontName);
    }
    
    public static void setFontNameProperties(StyleTextPropertiesElement properties, String fontName, String fontNameAsian, String fontNameComplex) {
        if (fontName != null) {
            properties.setStyleFontNameAttribute(fontName);
        }
        if (fontNameAsian != null) {
            properties.setStyleFontNameAsianAttribute(fontNameAsian);
        }
        if (fontNameComplex != null) {
            properties.setStyleFontNameComplexAttribute(fontNameComplex);
        }
    }        
    
    public static void setFontSizeProperties(StyleTextPropertiesElement properties, String fontSize) {
        TextStyleFactory.setFontSizeProperties(properties, fontSize, fontSize, fontSize);
    }
    
    public static void setFontSizeProperties(StyleTextPropertiesElement properties, String fontSize, String fontSizeAsian, String fontSizeComplex) {
        if (fontSize != null) {
            properties.setFoFontSizeAttribute(fontSize);
        }
        if (fontSizeAsian != null) {
            properties.setStyleFontSizeAsianAttribute(fontSizeAsian);
        }
        if (fontSizeComplex != null) {
            properties.setStyleFontSizeComplexAttribute(fontSizeComplex);
        }
    }
    
    public static void setFontStyleProperties(StyleTextPropertiesElement properties, String fontStyle) {
        TextStyleFactory.setFontStyleProperties(properties,  fontStyle, fontStyle, fontStyle);
    }
    
    public static void setFontStyleProperties(StyleTextPropertiesElement properties, String fontStyle, String fontStyleAsian, String fontStyleComplex) {
        if (fontStyle != null) {
            properties.setFoFontStyleAttribute(fontStyle);
        }
        if (fontStyleAsian != null) {
            properties.setStyleFontStyleAsianAttribute(fontStyleAsian);
        }
        if (fontStyleComplex != null) {
            properties.setStyleFontStyleComplexAttribute(fontStyleComplex);
        }
    }    
    
    public static void setFontWeightProperties(StyleTextPropertiesElement properties, String fontWeight, String fontWeightAsian, String fontWeightComplex) {
        if (fontWeight != null) {
            properties.setFoFontWeightAttribute(fontWeight);
        }
        if (fontWeightAsian != null) {
            properties.setStyleFontWeightAsianAttribute(fontWeightAsian);
        }
        if (fontWeightComplex != null) {
            properties.setStyleFontWeightComplexAttribute(fontWeightComplex);
        }
    }
    
    public static String constructTextStyleWithFontStyle(OdfContext odfContext, String fontStyle) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontStyleProperties(textProperties, fontStyle);
        
        return stylesOfficeStyles.getTextStyle(textProperties);
    }
    
    public static String constructTextStyleWithFontName(OdfContext odfContext, String fontName) {
        Styles stylesOfficeStyles = odfContext.getStylesOfficeStyles();
        
        StyleTextPropertiesElement textProperties = stylesOfficeStyles.constructTextProperties();
        TextStyleFactory.setFontNameProperties(textProperties, fontName);
        
        return stylesOfficeStyles.getTextStyle(textProperties);        
    }
}
