/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 13.04.2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.style;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;


public class StyleRepository {
    
    private Set<String> styleNames = new HashSet<String>();
    private Map<String, String> keyToStyleName = new HashMap<String, String>();
    
    public boolean containsKey(String key) {
        return this.keyToStyleName.containsKey(key);
    }
    
    public int size() {
        return this.keyToStyleName.size();
    }
    
    public boolean containsStyleName(String styleName) {
        return this.styleNames.contains(styleName);
    }
    
    public String getStyleName(String key) {
        return this.keyToStyleName.get(key);
    }
    
    public void register(String key, String styleName) {
        this.styleNames.add(styleName);
        this.keyToStyleName.put(key, styleName);
    }
    
}
