/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 07.12.2016
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.style;

import org.clazzes.util.lang.Pair;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopsElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;

public class ParagraphStyleFactory {

    public static void setMarginAttributes(StyleParagraphPropertiesElement paragraphProperties, String marginLeft, String marginRight, String marginTop, String marginBottom) {
        if (marginLeft != null) {
            paragraphProperties.setFoMarginLeftAttribute(marginLeft);
        }
        if (marginRight != null) {
            paragraphProperties.setFoMarginRightAttribute(marginRight);
        }
        if (marginTop != null) {
            paragraphProperties.setFoMarginTopAttribute(marginTop);
        }
        if (marginBottom != null) {
            paragraphProperties.setFoMarginBottomAttribute(marginBottom);
        }        
    }
    
    public static void setLineAttributes(StyleParagraphPropertiesElement paragraphProperties, Boolean numberLines, Integer lineNumber) {
        if (numberLines != null) {
            paragraphProperties.setTextNumberLinesAttribute(numberLines);
        }
        if (lineNumber != null) {
            paragraphProperties.setTextLineNumberAttribute(lineNumber);
        }
    }
    
    public static void addTabStops(StyleParagraphPropertiesElement paragraphProperties, String... tabStops) {
        StyleTabStopsElement tabStopsElement = (StyleTabStopsElement)((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopsElement.class);
        
        for (String tabStop : tabStops) {
            StyleTabStopElement tabStopElement = (StyleTabStopElement)((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopElement.class);
            tabStopElement.setStylePositionAttribute(tabStop);
            
            tabStopsElement.appendChild(tabStopElement);
        }
        
        paragraphProperties.appendChild(tabStopsElement);
    }
    
    @SafeVarargs
    public static void addTabStops(StyleParagraphPropertiesElement paragraphProperties, Pair<String, String>... tabStops) {
        StyleTabStopsElement tabStopsElement = (StyleTabStopsElement)((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopsElement.class);
        
        for (Pair<String, String> tabStop : tabStops) {
            StyleTabStopElement tabStopElement = (StyleTabStopElement)((OdfFileDom)paragraphProperties.getOwnerDocument()).newOdfElement(StyleTabStopElement.class);
            tabStopElement.setStylePositionAttribute(tabStop.getFirst());
            tabStopElement.setStyleTypeAttribute(tabStop.getSecond());
            
            tabStopsElement.appendChild(tabStopElement);
        }
        
        paragraphProperties.appendChild(tabStopsElement);
    }    
}
