/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 03.08.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.style;

import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDayElement;
import org.odftoolkit.odfdom.dom.element.number.NumberMonthElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.number.NumberYearElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;

public class NumberStyleFactory {
    public static NumberNumberStyleElement constructNumberNumberStyleElement(Styles styles) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberNumberStyleElement numberNumberStyleElement = (NumberNumberStyleElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberNumberStyleElement.class);
        return numberNumberStyleElement;
    }
    
    public static NumberNumberElement constructNumberNumberElement(Styles styles, Integer minIntegerDigits) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberNumberElement numberNumberElement = (NumberNumberElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberNumberElement.class);
        if (minIntegerDigits != null) {
            numberNumberElement.setNumberMinIntegerDigitsAttribute(minIntegerDigits);    
        }        
        return numberNumberElement;        
    }
    
    public static NumberDateStyleElement constructNumberDateStyleElement(Styles styles, String language, String country, Boolean automaticOrder) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberDateStyleElement numberDateStyleElement = (NumberDateStyleElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberDateStyleElement.class);
        
        if (language != null) {
            numberDateStyleElement.setNumberLanguageAttribute(language);
        }
        if (country != null) {
            numberDateStyleElement.setNumberCountryAttribute(country);
        }
        if (automaticOrder != null) {
            numberDateStyleElement.setNumberAutomaticOrderAttribute(automaticOrder);
        }
        
        return numberDateStyleElement;
    }    
    
    public static NumberDayElement constructNumberDayElement(Styles styles, String style) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberDayElement numberDayElement = (NumberDayElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberDayElement.class);
        if (style != null) {
            numberDayElement.setNumberStyleAttribute(style);
        }        
        return numberDayElement;        
    }
    
    public static NumberMonthElement constructNumberMonthElement(Styles styles, String style) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberMonthElement numberMonthElement = (NumberMonthElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberMonthElement.class);
        if (style != null) {
            numberMonthElement.setNumberStyleAttribute(style);
        }        
        return numberMonthElement;        
    }
    
    public static NumberYearElement constructNumberYearElement(Styles styles, String style) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberYearElement numberYearElement = (NumberYearElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberYearElement.class);
        if (style != null) {
            numberYearElement.setNumberStyleAttribute(style);
        }        
        return numberYearElement;        
    }
    
    public static NumberTextElement constructNumberTextElement(Styles styles, String content) {
        OdfElement stylesElement = styles.getStylesElement();
        NumberTextElement numberTextElement = (NumberTextElement)((OdfFileDom)stylesElement.getOwnerDocument()).newOdfElement(NumberTextElement.class);
        if (content != null) {
            numberTextElement.setTextContent(content);
        }        
        return numberTextElement;        
    }    
}
