/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 04.10.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.html;

import java.util.List;

import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.text.TextFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class OdfFromHtmlConverter {
    
    private static final Logger log = LoggerFactory.getLogger(OdfFromHtmlConverter.class);

    public static Node convert(Node parentNode, String html, String baseTextStyle, Styles styles) {
        Document document = Jsoup.parse(html);
        Element body = document.body();
        
        Node odfBaseNode = TextFactory.constructTextNode(parentNode, "", baseTextStyle);
        boolean allSupported = OdfFromHtmlConverter.constructChildNodes(odfBaseNode, body.childNodes(), baseTextStyle, styles);
        if (!allSupported) {
            parentNode.removeChild(odfBaseNode);
            TextFactory.constructTextNode(parentNode, html, baseTextStyle);
        }

        return odfBaseNode;
    }
    
    private static boolean constructChildNodes(Node node, List<org.jsoup.nodes.Node> jsoupNodes, String baseTextStyle, Styles styles) {
        boolean allSupported = true;
        for (org.jsoup.nodes.Node jsoupNode : jsoupNodes) {
            if (jsoupNode instanceof TextNode) {
                TextNode textNode = (TextNode)jsoupNode;
                TextFactory.constructTextSpan(node, textNode.getWholeText(), baseTextStyle);
            } else if (jsoupNode instanceof Element) {
                Element jsoupElement = (Element)jsoupNode;
                String tag = jsoupElement.tagName();
                //TextSpanElement span = TextFactory.constructTextSpan(node, "", baseTextStyle);
                if ("b".equals(tag)) {
                    String style = styles.getTextStyle(styles.constructTextPropertiesWithFontWeight("bold"));
                    allSupported &= OdfFromHtmlConverter.constructChildNodes(node, jsoupElement.childNodes(), style, styles);
                } else if ("u".equals(tag)) {
                    String style = styles.getTextStyle(styles.constructUnderlineTextProperties("solid", "auto", "font-color"));
                    allSupported &= OdfFromHtmlConverter.constructChildNodes(node, jsoupElement.childNodes(), style, styles);                    
                } else {
                    log.warn("Ignored unsupported html tag [" + tag + "] while converting from html to odf, falling back to plain text output");
                    allSupported = false;
                }
            }
        }
        return allSupported;
    }    
}
