/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 09.04.2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.file;

import java.io.File;

import org.clazzes.ooo.engine.OOoFileConversionTicket.TargetFileType;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.datetime.UtcTimestamp;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;

public class OdfFileHelper {
    
    public static File createTempFile(String dirName, String prefix) {
        File tmpDir = new File(dirName);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        UtcTimestamp now = UtcTimestamp.now();
        String fileNamePrefix = prefix + now.getYear() + (now.getMonth() < 10 ? "0" : "") + now.getMonth() 
                + (now.getDay() < 10 ? "0" : "") + now.getDay() 
                + (now.getHour() < 10 ? "0" : "") + now.getHour() 
                + (now.getMinute() < 10 ? "0" : "") + now.getMinute() 
                + (now.getSecond() < 10 ? "0" : "") + now.getSecond();
        String odtFileName = fileNamePrefix + ".odt"; 
        
        File file = new File(tmpDir, odtFileName);
        file.deleteOnExit();
        return file;
    }
    
    public static void save(OdfTextDocument document, File odtFile) {
        try {
            document.save(odtFile);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }           
    }
    
    public static void save(OdfSpreadsheetDocument document, File odsFile) {
        try {
            document.save(odsFile);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    
    public static File save(String dirName, String prefix, OdfTextDocument document) {
        File odtFile = OdfFileHelper.createTempFile(dirName, prefix);
        OdfFileHelper.save(document, odtFile);
        return odtFile;
    }
    
    public static File save(String dirName, String prefix, OdfSpreadsheetDocument document) {
        File odsFile = OdfFileHelper.createTempFile(dirName, prefix);
        OdfFileHelper.save(document, odsFile);
        return odsFile;
    }    
    
    public static String saveAndConvert(String dirName, String prefix, OdfTextDocument document, TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout, Integer slotId, OdfConversionHandle handle) {
        File odtFile = OdfFileHelper.save(dirName, prefix, document);
        String targetFileName = ConversionHelper.convert(odtFile, TargetFileType.PDF, oooFileEngine, timeout, slotId, handle);
        return targetFileName;
    }    
    
    public static String saveAndConvert(String dirName, String prefix, OdfTextDocument document, TargetFileType targetFileType, OOoFileEngine oooFileEngine) {
        File odtFile = OdfFileHelper.save(dirName, prefix, document);
        String targetFileName = ConversionHelper.convert(odtFile, TargetFileType.PDF, oooFileEngine);
        return targetFileName;
    }
    
    
    
    public static String saveAndConvert(String dirName, String prefix, OdfSpreadsheetDocument document, TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout, Integer slotId, OdfConversionHandle handle) {
        File odtFile = OdfFileHelper.save(dirName, prefix, document);
        String targetFileName = ConversionHelper.convert(odtFile, TargetFileType.MSEXCEL_2007_XML, oooFileEngine, timeout, slotId, handle);
        return targetFileName;
    }
}
