/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 09.04.2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.file;

import java.io.File;

import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileConversionTicket.TargetFileType;
import org.clazzes.ooo.engine.OOoFileEngine;

public class ConversionHelper {
    
    public static String convert(File odtFile, TargetFileType targetFileType, OOoFileEngine oooFileEngine) {
        return ConversionHelper.convert(odtFile, targetFileType, oooFileEngine, 60000l);
    }
    
    public static String convert(File odtFile, TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout) {
        return ConversionHelper.convert(odtFile, targetFileType, oooFileEngine, timeout, null, null);
    }    
        
    public static String convert(File odtFile, TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout, Integer slotId, OdfConversionHandle handle) {
        if (timeout == null) {
            timeout = 60000l;
        }
        
        OOoFileConversionTicket conversionTicket = new OOoFileConversionTicket();
        conversionTicket.setSlotId(slotId);
        conversionTicket.setKeepOOoFile(true);
        conversionTicket.setKeepTargetFile(true);
        conversionTicket.setOooFileName(odtFile.getAbsolutePath());
        
        String odtFileName = odtFile.getName();
        int lastDotPosition = odtFileName.lastIndexOf('.');
        String prefix = lastDotPosition != -1 ? odtFileName.substring(0, lastDotPosition) : odtFileName;
        
        File parentDirectory = odtFile.getParentFile();
        
        String targetFileName = prefix + "." + targetFileType.toExtension();
        File targetFile = new File(parentDirectory, targetFileName);
        conversionTicket.setTargetFileName(targetFile.getAbsolutePath());
        conversionTicket.setTargetFileType(targetFileType);

        oooFileEngine.queueTicket(conversionTicket);
        if (handle != null) {
            handle.setTicket(conversionTicket);
        }
        
        //TicketStatus status = 
        conversionTicket.getStatusAndWaitForCompletion(timeout);
        if (!conversionTicket.isClosedOK()) {
            throw new RuntimeException("conversionTicket failed.");
        }
        
        return targetFile.getAbsolutePath();
    }
}
