/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 24.08.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.factory;

import org.odftoolkit.odfdom.dom.element.text.TextBookmarkElement;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkRefElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class ReferenceFactory {

    public static TextBookmarkElement appendAnchor(Node parentNode, String name) {
        TextBookmarkElement bookmark = (TextBookmarkElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextBookmarkElement.class);
        
        bookmark.setTextNameAttribute(name);    
        
        parentNode.appendChild(bookmark);
        return bookmark;
    }
    
    public static TextBookmarkRefElement appendReference(Node parentNode, String format, String name, String label) {
        TextBookmarkRefElement bookmarkRef = (TextBookmarkRefElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextBookmarkRefElement.class);
        
        bookmarkRef.setTextReferenceFormatAttribute(format);
        bookmarkRef.setTextRefNameAttribute(name);

        if (label != null) {
            bookmarkRef.setTextContent(label);
        }
        
        parentNode.appendChild(bookmarkRef);
        return bookmarkRef;
    }
    
}
