/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 06.12.2016
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.draw;

import org.clazzes.odf.util.style.Styles;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class FrameFactory {
    
    public static DrawFrameElement constructDrawFrameNode(Node parentNode, String styleName, String anchorType, String x, String y, String width, String height, Integer zIndex) {
        DrawFrameElement drawFrameElement = (DrawFrameElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(DrawFrameElement.class);
        
        if (styleName != null) {
            drawFrameElement.setStyleName(styleName);
        }
        if (anchorType != null) {
            drawFrameElement.setTextAnchorTypeAttribute(anchorType);
        }
        if (x != null) {
            drawFrameElement.setSvgXAttribute(x);
        }
        if (y != null) {
            drawFrameElement.setSvgYAttribute(y);
        }
        if (width != null) {
            drawFrameElement.setSvgWidthAttribute(width);
        }
        if (height != null) {
            drawFrameElement.setSvgHeightAttribute(height);
        }
        if (zIndex != null) {
            drawFrameElement.setDrawZIndexAttribute(zIndex);
        }
        
        parentNode.appendChild(drawFrameElement);
        return drawFrameElement;
    }
    
    public static StyleGraphicPropertiesElement constructFrameParentProperties(Styles stylesStyles) {
        StyleGraphicPropertiesElement frameProperties = stylesStyles.constructGraphicProperties();
        frameProperties.setTextAnchorTypeAttribute("paragraph");
        frameProperties.setSvgXAttribute("0cm");
        frameProperties.setSvgYAttribute("0cm");
        frameProperties.setFoMarginAttribute("0cm");
        frameProperties.setStyleWrapAttribute("parallel");
        frameProperties.setStyleWrapContourAttribute(false);
        frameProperties.setStyleVerticalPosAttribute("top");
        frameProperties.setStyleVerticalRelAttribute("paragraph-content");
        frameProperties.setStyleHorizontalPosAttribute("center");
        frameProperties.setStyleHorizontalRelAttribute("paragraph-content");
        
        return frameProperties;
    }
    
    public static StyleGraphicPropertiesElement constructFrameProperties(Styles contentAutomaticStyles, String wrap, String horizontalPos) {
        StyleGraphicPropertiesElement graphicProperties = contentAutomaticStyles.constructGraphicProperties();
        //style:number-wrapped-paragraphs="no-limit" style:flow-with-text="true"/>      
        graphicProperties.setStyleRunThroughAttribute("foreground");
        graphicProperties.setStyleWrapAttribute(wrap != null ? wrap : "right");
        graphicProperties.setStyleVerticalPosAttribute("from-top");
        graphicProperties.setStyleHorizontalPosAttribute(horizontalPos != null ? horizontalPos : "from-left");
        graphicProperties.setStyleHorizontalRelAttribute("paragraph");
        graphicProperties.setStyleFlowWithTextAttribute(true);        
        
        return graphicProperties;
    }
    
    public static StyleGraphicPropertiesElement constructImageFrameParentProperties(Styles stylesStyles) {
        StyleGraphicPropertiesElement properties = stylesStyles.constructGraphicProperties();
        properties.setTextAnchorTypeAttribute("paragraph");
        properties.setSvgXAttribute("0cm");
        properties.setSvgYAttribute("0cm");
        properties.setStyleWrapAttribute("dynamic");
        properties.setStyleWrapContourAttribute(false);
        properties.setStyleVerticalPosAttribute("top");
        properties.setStyleVerticalRelAttribute("paragraph");
        properties.setStyleHorizontalPosAttribute("center");
        properties.setStyleHorizontalRelAttribute("paragraph");
        return properties;
    }
    
    public static StyleGraphicPropertiesElement constructImageFrameProperties(Styles contentAutomaticStyles) {
        StyleGraphicPropertiesElement properties = contentAutomaticStyles.constructGraphicProperties();
        properties.setStyleMirrorAttribute("none");
        properties.setFoClipAttribute("rect(0cm, 0cm, 0cm, 0cm)");
        properties.setDrawLuminanceAttribute("0%");
        properties.setDrawContrastAttribute("0cm");
        properties.setDrawRedAttribute("0%");
        properties.setDrawGreenAttribute("0%");
        properties.setDrawBlueAttribute("0%");
        properties.setDrawGammaAttribute("100%");
        properties.setDrawColorInversionAttribute(false);
        properties.setDrawImageOpacityAttribute("100%");
        properties.setDrawColorModeAttribute("standard");     
        return properties;
    }
}
