/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 20.04.2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.core;

import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.StyleRepository;
import org.clazzes.odf.util.style.Styles;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;

public class OdfContext {
    
    private OfficeDocumentElement documentElement;
    
    private String stylePrefix;
    private StyleRepository styleRepository = new StyleRepository();
    
    private Styles stylesOfficeStyles;
    private AutomaticStyles stylesAutomaticStyles;
    
    private Styles contentOfficeStyles;
    private AutomaticStyles contentAutomaticStyles;
    private OfficeBodyElement officeBodyElement;
    
    public OdfContext(OdfDocument document, String stylePrefix) throws Exception {
        this.stylePrefix = stylePrefix;
        this.documentElement = null;
        this.officeBodyElement = null;
        
        OdfStylesDom stylesDom = document.getStylesDom();
        OdfOfficeStyles stylesOfficeStylesElement = stylesDom.getOfficeStyles();
        OdfOfficeAutomaticStyles stylesAutomaticStylesElement = stylesDom.getAutomaticStyles();

        this.stylesOfficeStyles = new Styles(this.styleRepository, stylesOfficeStylesElement, stylePrefix);
        this.stylesAutomaticStyles = new AutomaticStyles(this.styleRepository, stylesAutomaticStylesElement, stylePrefix);
        
        OdfContentDom contentDom = document.getContentDom();
        
        OdfOfficeStyles contentOfficeStylesElement = (OdfOfficeStyles)OdfElement.findFirstChildNode(OdfOfficeStyles.class, contentDom.getFirstChild());
        OdfOfficeAutomaticStyles contentAutomaticStylesElement = contentDom.getAutomaticStyles();
        this.contentOfficeStyles = new Styles(this.styleRepository, contentOfficeStylesElement, stylePrefix);
        this.contentAutomaticStyles = new AutomaticStyles(this.styleRepository, contentAutomaticStylesElement, stylePrefix);
    }
    
    public OdfContext(OfficeDocumentElement documentElement, String stylePrefix, OdfElement stylesOfficeStylesElement, OdfOfficeAutomaticStyles stylesAutomaticStylesElement, OfficeBodyElement officeBodyElement) {
        this.documentElement = documentElement;
        this.officeBodyElement = officeBodyElement;

        this.stylesOfficeStyles = new Styles(this.styleRepository, stylesOfficeStylesElement, stylePrefix);
        this.stylesAutomaticStyles = new AutomaticStyles(this.styleRepository, stylesAutomaticStylesElement, stylePrefix);
        
        this.contentOfficeStyles = null;
        this.contentAutomaticStyles = null;
    }
    
    public OfficeDocumentElement getDocumentElement() {
        return this.documentElement;
    }
    
    public OfficeBodyElement getOfficeBodyElement() {
        return this.officeBodyElement;
    }
    
    public String getStylePrefix() {
        return this.stylePrefix;
    }
    
    public Styles getStylesOfficeStyles() {
        return this.stylesOfficeStyles;
    }
    
    public AutomaticStyles getStylesAutomaticStyles() {
        return this.stylesAutomaticStyles;
    }
    
    public Styles getContentOfficeStyles() {
        return this.contentOfficeStyles;
    }
    
    public Styles getContentAutomaticStyles() {
        return this.contentAutomaticStyles;
    }
}
