/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 16.05.2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.core;

import java.util.ArrayList;
import java.util.List;

import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeHelper {
    
    @SuppressWarnings("unchecked")
    public static <T> List<T> getChildNodes(ParentNode parentNode, Class<T> clazz) {
        List<T> childList = new ArrayList<T>();
        NodeList childNodeList = parentNode.getChildNodes();
        for (int n = 0; n < childNodeList.getLength(); n++) {
            Node childNode = childNodeList.item(n);
            if (clazz.equals(childNode.getClass())) {
                childList.add((T)childNode);                
            }
        }
        
        return childList;
    }
    
    @SuppressWarnings("unchecked")
    public static <T extends Node> void removeChildNodes(ParentNode parentNode, Class<T> clazz) {
        List<T> nodesToRemove = new ArrayList<T>();
        
        NodeList childNodeList = parentNode.getChildNodes();
        for (int n = 0; n < childNodeList.getLength(); n++) {
            Node childNode = childNodeList.item(n);
            if (clazz.equals(childNode.getClass())) {
                nodesToRemove.add((T)childNode);
            }
        }
        
        for (T nodeToRemove : nodesToRemove) {
            parentNode.removeChild(nodeToRemove);
        }
    }

}
