/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 03.08.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.chart;

import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;

public abstract class OdfChartColumn<T> {
    private boolean headerColumn;
    private String name;
    private String label;
    
    public OdfChartColumn(String name, String label) {
        this.headerColumn = false;
        this.name = name;
        this.label = label;
    }    
    
    public OdfChartColumn(boolean headerColumn, String name, String label) {
        this.headerColumn = headerColumn;
        this.name = name;
        this.label = label;
    }
    
    public boolean isHeaderColumn() {
        return headerColumn;
    }

    public void setHeaderColumn(boolean headerColumn) {
        this.headerColumn = headerColumn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public abstract void appendDataTableCell(TableTableRowElement rowElement, T data);    
}
