/***********************************************************
 * $Id: $
 * 
 * Utility code for dealing with odf files using odfdom etc.
 * http://www.clazzes.org
 *
 * Created: 03.08.2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.odf.util.chart;

import org.odftoolkit.odfdom.dom.element.chart.ChartAxisElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartCategoriesElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartChartElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartDataPointElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartFloorElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartGridElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartLegendElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartPlotAreaElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartSeriesElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartWallElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeChartElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class ChartFactory {

    public static OfficeChartElement constructOfficeChart(Node parentNode) {
        OfficeChartElement officeChartElement = (OfficeChartElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(OfficeChartElement.class);
        
        parentNode.appendChild(officeChartElement);
        return officeChartElement;
    }
    
    public static ChartChartElement constructChartChart(Node parentNode, String width, String height, String chartClass, String styleName) {
        ChartChartElement chartChartElement = (ChartChartElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartChartElement.class);
        chartChartElement.setSvgWidthAttribute(width);
        chartChartElement.setSvgHeightAttribute(height);
        chartChartElement.setXlinkHrefAttribute(".");
        chartChartElement.setXlinkTypeAttribute("simple");
        chartChartElement.setChartClassAttribute(chartClass);
        if (styleName != null) {
            chartChartElement.setChartStyleNameAttribute(styleName);    
        }        
        
        parentNode.appendChild(chartChartElement);
        return chartChartElement;
    }
    
    public static ChartLegendElement constructChartLegend(Node parentNode, String legendPosition, String x, String y, String legendExpansion, String styleName) {
        ChartLegendElement chartLegendElement = (ChartLegendElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartLegendElement.class);        
        chartLegendElement.setChartLegendPositionAttribute(legendPosition);
        chartLegendElement.setSvgXAttribute(x);
        chartLegendElement.setSvgYAttribute(y);
        chartLegendElement.setStyleLegendExpansionAttribute(legendExpansion);
        if (styleName != null) {
            chartLegendElement.setStyleName(styleName);    
        }        
        
        parentNode.appendChild(chartLegendElement);
        return chartLegendElement;    
    }
    
    public static ChartPlotAreaElement constructChartPlotArea(Node parentNode, String x, String y, String width, String height, String dataSourceHasLabels, String styleName) {
        ChartPlotAreaElement chartPlotAreaElement = (ChartPlotAreaElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartPlotAreaElement.class);        
        chartPlotAreaElement.setSvgXAttribute(x);
        chartPlotAreaElement.setSvgYAttribute(y);
        chartPlotAreaElement.setSvgWidthAttribute(width);
        chartPlotAreaElement.setSvgHeightAttribute(height);
        if (dataSourceHasLabels != null) {
            chartPlotAreaElement.setChartDataSourceHasLabelsAttribute(dataSourceHasLabels);
        } else {
            chartPlotAreaElement.setChartDataSourceHasLabelsAttribute("both");
        }
        if (styleName != null) {
            chartPlotAreaElement.setStyleName(styleName);
        }
        
        parentNode.appendChild(chartPlotAreaElement);
        return chartPlotAreaElement;
    }
    
    public static ChartAxisElement constructChartAxis(Node parentNode, String dimension, String name, String styleName) {
        ChartAxisElement chartAxisElement = (ChartAxisElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartAxisElement.class);
        chartAxisElement.setChartDimensionAttribute(dimension);
        chartAxisElement.setChartNameAttribute(name);
        if (styleName != null) {
            chartAxisElement.setStyleName(styleName);    
        }
        // TODO: x axis has additional, unsupported, attribute chartooo:axis-type = "auto" --- is it needed?
        parentNode.appendChild(chartAxisElement);
        return chartAxisElement;        
    }
    
    public static ChartCategoriesElement constructChartCategories(Node parentNode, String tableName, int numberOfCategories) {
        int firstLine = 2;
        int lastLine = firstLine + numberOfCategories - 1;
        String cellRangeAddress = tableName + ".$A$" + firstLine + ":.$A$" + lastLine;
        return ChartFactory.constructChartCategories(parentNode, cellRangeAddress);
    }
    
    public static ChartCategoriesElement constructChartCategories(Node parentNode, String cellRangeAddress) {
        ChartCategoriesElement chartCategoriesElement = (ChartCategoriesElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartCategoriesElement.class);
        chartCategoriesElement.setTableCellRangeAddressAttribute(cellRangeAddress);
        
        parentNode.appendChild(chartCategoriesElement);
        return chartCategoriesElement;
    }
    
    public static ChartGridElement constructChartGrid(Node parentNode, String chartClass, String styleName) {
        ChartGridElement chartGridElement = (ChartGridElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartGridElement.class);
        chartGridElement.setChartClassAttribute(chartClass);
        if (styleName != null) {
            chartGridElement.setStyleName(styleName);
        }
        
        parentNode.appendChild(chartGridElement);
        return chartGridElement;
    }
    
    public static ChartSeriesElement constructChartSeries(Node parentNode, String tableName, int numberOfCategories, String chartClass, String styleName) {
        int firstLine = 2;
        int lastLine = firstLine + numberOfCategories - 1;        
        
        String valuesCellRangeAddress = tableName + ".$B$" + firstLine + ":.$B$" + lastLine;
        String labelCellAddress = tableName + ".$B$1";
        
        return ChartFactory.constructChartSeries(parentNode, valuesCellRangeAddress, labelCellAddress, chartClass, styleName);
    }
    
    public static ChartSeriesElement constructChartSeries(Node parentNode, String valuesCellRangeAddress, String labelCellAddress, 
                                                          String chartClass, String styleName) {
        ChartSeriesElement chartSeriesElement = (ChartSeriesElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartSeriesElement.class);
        
        chartSeriesElement.setChartValuesCellRangeAddressAttribute(valuesCellRangeAddress);
        chartSeriesElement.setChartLabelCellAddressAttribute(labelCellAddress);
        chartSeriesElement.setChartClassAttribute(chartClass);
        if (styleName != null) {
            chartSeriesElement.setStyleName(styleName);    
        }
        
        parentNode.appendChild(chartSeriesElement);
        return chartSeriesElement;
    }

    public static ChartDataPointElement constructChartDataPoint(Node parentNode, String styleName) {
        ChartDataPointElement chartDataPointElement = (ChartDataPointElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartDataPointElement.class);
        if (styleName != null) {
            chartDataPointElement.setStyleName(styleName);
        }
        
        parentNode.appendChild(chartDataPointElement);
        return chartDataPointElement;
    }
    
    public static ChartWallElement constructChartWall(Node parentNode, String styleName) {
        ChartWallElement chartWallElement = (ChartWallElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartWallElement.class);
        if (styleName != null) {
            chartWallElement.setStyleName(styleName);
        }
        
        parentNode.appendChild(chartWallElement);
        return chartWallElement;        
    }
    
    public static ChartFloorElement constructChartFloor(Node parentNode, String styleName) {
        ChartFloorElement chartFloorElement = (ChartFloorElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(ChartFloorElement.class);
        if (styleName != null) {
            chartFloorElement.setStyleName(styleName);
        }
        
        parentNode.appendChild(chartFloorElement);
        return chartFloorElement;        
    }
}
