/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.tools;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.clazzes.jdbc2xml.schema.TableFilter;

public class ProcessRestrictionFilter
implements TableFilter {
    protected String[] excludedTableNames = null;
    protected Map<String, String> primaryRestrictions;
    protected Map<String, String> tableClauses;
    protected boolean processSchema = true;
    protected boolean processData = true;
    protected boolean processConstraints = true;
    protected boolean processXmlSchemaCheck = false;
    protected boolean prettyPrintXml = true;
    private boolean keepInternalIndices = false;
    private boolean createFKIndices = false;
    private boolean transactional = false;
    private boolean checkForAutoIncrementColumns = true;
    private int batchSize = 1000;
    private String idMapper;
    Map<String, String> dialectProps;

    @Override
    public boolean processTable(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            return false;
        }
        if (this.excludedTableNames != null) {
            for (String excludedTable : this.excludedTableNames) {
                if (!tableName.equalsIgnoreCase(excludedTable)) continue;
                return false;
            }
        }
        if (tableName.startsWith("JDBC2XML__")) {
            return false;
        }
        if (this.tableClauses == null) {
            return true;
        }
        return this.tableClauses.containsKey(tableName.toLowerCase(Locale.ENGLISH));
    }

    public String[] getExcludedTableNames() {
        return this.excludedTableNames;
    }

    public void setExcludedTableNames(String[] excludedTableNames) {
        this.excludedTableNames = excludedTableNames;
    }

    public boolean isProcessData() {
        return this.processData;
    }

    public void setProcessData(boolean processData) {
        this.processData = processData;
    }

    public boolean isProcessConstraints() {
        return this.processConstraints;
    }

    public void setProcessConstraints(boolean processConstraints) {
        this.processConstraints = processConstraints;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isProcessXmlSchemaCheck() {
        return this.processXmlSchemaCheck;
    }

    public void setProcessXmlSchemaCheck(boolean processXmlSchemaCheck) {
        this.processXmlSchemaCheck = processXmlSchemaCheck;
    }

    public boolean isPrettyPrintXml() {
        return this.prettyPrintXml;
    }

    public void setPrettyPrintXml(boolean prettyPrintXml) {
        this.prettyPrintXml = prettyPrintXml;
    }

    @Override
    public boolean isKeepInternalIndices() {
        return this.keepInternalIndices;
    }

    public void setKeepInternalIndices(boolean keepInternalIndices) {
        this.keepInternalIndices = keepInternalIndices;
    }

    public boolean isCreateFKIndices() {
        return this.createFKIndices;
    }

    public void setCreateFKIndices(boolean createFKIndices) {
        this.createFKIndices = createFKIndices;
    }

    public Map<String, String> getPrimaryRestrictions() {
        return this.primaryRestrictions;
    }

    public void setPrimaryRestrictions(Map<String, String> primaryRestrictions) {
        this.primaryRestrictions = primaryRestrictions;
    }

    public void addPrimaryRestriction(String table, String pkValue) {
        if (this.primaryRestrictions == null) {
            this.primaryRestrictions = new HashMap<String, String>();
        }
        this.primaryRestrictions.put(table, pkValue);
    }

    public String getIdMapper() {
        return this.idMapper;
    }

    public void setIdMapper(String idMapper) {
        this.idMapper = idMapper;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    @Override
    public boolean isCheckForAutoIncrementColumns() {
        return this.checkForAutoIncrementColumns;
    }

    public void setCheckForAutoIncrementColumns(boolean checkForAutoIncrementColumns) {
        this.checkForAutoIncrementColumns = checkForAutoIncrementColumns;
    }

    public boolean isProcessSchema() {
        return this.processSchema;
    }

    public void setProcessSchema(boolean processSchema) {
        this.processSchema = processSchema;
    }

    public Map<String, String> getDialectProps() {
        return this.dialectProps;
    }

    public void setDialectProps(Map<String, String> dialectProps) {
        this.dialectProps = dialectProps;
    }

    public void addDialectProp(String key, String value) {
        if (this.dialectProps == null) {
            this.dialectProps = new HashMap<String, String>();
        }
        this.dialectProps.put(key, value);
    }

    public Map<String, String> getTableClauses() {
        return this.tableClauses;
    }

    public void setTableClauses(Map<String, String> whereClauses) {
        this.tableClauses = whereClauses;
    }

    public void addTableClause(String table, String whereClause) {
        if (this.tableClauses == null) {
            this.tableClauses = new HashMap<String, String>();
        }
        this.tableClauses.put(table.toLowerCase(Locale.ENGLISH), whereClause);
    }

    public String getTableClause(String table) {
        if (this.tableClauses == null) {
            return null;
        }
        return this.tableClauses.get(table.toLowerCase(Locale.ENGLISH));
    }
}

