/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.sax.InsertContentHandler;
import org.clazzes.jdbc2xml.sax.JDBC2XMLSchemaHelper;
import org.clazzes.jdbc2xml.sax.JDBCToSAXWriter;
import org.clazzes.jdbc2xml.sax.XmlPretty;
import org.clazzes.jdbc2xml.sax.XmlPrettyConfig;
import org.clazzes.jdbc2xml.sax.impl.ZipEntryResolver;
import org.clazzes.jdbc2xml.sax.impl.ZipFileContentHandler;
import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.clazzes.jdbc2xml.schema.IDialectFactory;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.schema.TableFilter;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.tools.DBDataExtractor;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;
import org.clazzes.util.xml.XMLSerializerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class Commands {
    private static Logger log = LoggerFactory.getLogger(Commands.class);

    public static void jdbc2xml(Connection fromConnection, OutputStream toStream, TimeZone timeZone, ProcessRestrictionFilter processRestrictionFilter) throws FileNotFoundException, TransformerConfigurationException, SQLException, SAXException {
        JDBCToSAXWriter writer = null;
        XmlPrettyConfig prettyConfig = new XmlPrettyConfig(2, 8);
        prettyConfig.addSingleLineTag(Constants.ROW_TAG_NAME);
        prettyConfig.setActive(processRestrictionFilter.isPrettyPrintXml());
        ContentHandler handler = null;
        if (toStream instanceof ZipOutputStream) {
            handler = new ZipFileContentHandler((ZipOutputStream)toStream, "content.xml", prettyConfig);
        } else {
            handler = XMLSerializerHelper.newSerializer((OutputStream)toStream);
            handler = new XmlPretty(handler, prettyConfig);
        }
        writer = new JDBCToSAXWriter(fromConnection, timeZone, handler);
        writer.setProcessRestrictionFilter(processRestrictionFilter);
        writer.processData();
        try {
            toStream.close();
        }
        catch (IOException e) {
            log.warn("error closing output stream", (Throwable)e);
        }
    }

    public static void jdbcping(Connection fromConnection) throws SQLException {
        DatabaseMetaData dbMetaData = fromConnection.getMetaData();
        StringBuffer sb = new StringBuffer();
        sb.append("DatabaseMetaData tell:\n");
        sb.append("Product Name:           " + dbMetaData.getDatabaseProductName() + "\n");
        sb.append("Product Version:        " + dbMetaData.getDatabaseProductVersion() + "\n");
        sb.append("Product Major Version:  " + dbMetaData.getDatabaseMajorVersion() + "\n");
        sb.append("Product Minor Version:  " + dbMetaData.getDatabaseMinorVersion() + "\n");
        sb.append("Driver Name:            " + dbMetaData.getDriverName() + "\n");
        sb.append("Driver Version:         " + dbMetaData.getDriverVersion() + "\n");
        sb.append("Driver Major Version:   " + dbMetaData.getDriverMajorVersion() + "\n");
        sb.append("Driver Minor Version:   " + dbMetaData.getDriverMinorVersion() + "\n");
        sb.append("JDBC Major Version:     " + dbMetaData.getJDBCMajorVersion() + "\n");
        sb.append("JDBC Minor Version:     " + dbMetaData.getJDBCMinorVersion() + "\n");
        log.info(sb.toString());
    }

    public static void xml2xml(Object inObject, OutputStream toStream, ProcessRestrictionFilter processRestrictionFilter) throws SAXException, ZipException, IOException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser sparser = parserFactory.newSAXParser();
        XMLReader parser = sparser.getXMLReader();
        parser.setFeature("http://apache.org/xml/features/xinclude", true);
        parser.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", true);
        ZipEntryResolver resolver = null;
        InputSource inputSource = null;
        if (inObject instanceof File) {
            resolver = new ZipEntryResolver(new ZipFile((File)inObject));
            inputSource = resolver.resolveEntity(null, "content.xml");
            parser.setEntityResolver(resolver);
        } else {
            inputSource = new InputSource((InputStream)inObject);
        }
        XmlPrettyConfig prettyConfig = new XmlPrettyConfig(2, 8);
        prettyConfig.addSingleLineTag(Constants.ROW_TAG_NAME);
        prettyConfig.setActive(processRestrictionFilter.isPrettyPrintXml());
        ContentHandler handler = null;
        if (toStream instanceof ZipOutputStream) {
            handler = new ZipFileContentHandler((ZipOutputStream)toStream, "content.xml", prettyConfig);
        } else {
            handler = XMLSerializerHelper.newSerializer((OutputStream)toStream);
            handler = new XmlPretty(handler, prettyConfig);
        }
        if (processRestrictionFilter.isProcessXmlSchemaCheck()) {
            Schema schema = JDBC2XMLSchemaHelper.createSchema();
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            validatorHandler.setContentHandler(handler);
            parser.setContentHandler(validatorHandler);
        } else {
            parser.setContentHandler(handler);
        }
        parser.parse(inputSource);
        try {
            toStream.close();
        }
        catch (IOException e) {
            log.warn("error closing output stream", (Throwable)e);
        }
    }

    public static void xml2jdbc(Object inObject, Connection toConnection, TimeZone timeZone, ProcessRestrictionFilter processRestrictionFilter) throws TransformerConfigurationException, SQLException, SAXException, IOException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser sparser = parserFactory.newSAXParser();
        XMLReader parser = sparser.getXMLReader();
        parser.setFeature("http://apache.org/xml/features/xinclude", true);
        parser.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", true);
        ZipEntryResolver resolver = null;
        InputSource inputSource = null;
        if (inObject instanceof File) {
            resolver = new ZipEntryResolver(new ZipFile((File)inObject));
            inputSource = resolver.resolveEntity(null, "content.xml");
        } else {
            inputSource = new InputSource((InputStream)inObject);
        }
        InsertContentHandler insertHandler = new InsertContentHandler(toConnection, timeZone);
        insertHandler.setProcessRestrictionFilter(processRestrictionFilter);
        if (processRestrictionFilter.isProcessXmlSchemaCheck()) {
            Schema schema = JDBC2XMLSchemaHelper.createSchema();
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            validatorHandler.setContentHandler((ContentHandler)((Object)insertHandler));
            parser.setContentHandler(validatorHandler);
        } else {
            parser.setContentHandler((ContentHandler)((Object)insertHandler));
        }
        parser.setEntityResolver(resolver);
        parser.parse(inputSource);
    }

    public static void jdbcExtract(Connection connection, String tempDB, TimeZone timeZone, ProcessRestrictionFilter processRestrictionFilter) throws SQLException, FileNotFoundException, TransformerConfigurationException, SAXException {
        log.info("Start extracting DB [" + connection.getCatalog() + "] to temporary database [" + tempDB + "].");
        IDialectFactory df = DialectFactory.newInstance();
        Dialect dialect = df.newDialect(connection.getMetaData());
        dialect.setProperties(processRestrictionFilter.getDialectProps());
        DBDataExtractor extractor = new DBDataExtractor();
        ISchemaEngine se = SchemaEngine.newInstance();
        se.setConnection(connection);
        se.setDialect(dialect);
        extractor.setSchemaEngine(se);
        extractor.setProcessRestrictionFilter(processRestrictionFilter);
        extractor.setExportDbName(tempDB);
        extractor.extract();
        log.info("Finished extracting to temporary databse [" + tempDB + "].");
    }

    public static void dropTables(Connection connection, TableFilter filter) throws SQLException {
        log.info("Start dropping all tables of DB [" + connection.getCatalog() + "]...");
        ISchemaEngine se = SchemaEngine.newInstance();
        se.setConnection(connection);
        List<TableInfo> tables = se.fetchTableInfos(filter);
        se.dropTables(tables, true);
        log.info("Successfully dropped all tables of DB [" + connection.getCatalog() + "].");
    }
}

