/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.serialization.impl;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;
import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.clazzes.util.datetime.ISO8601Format;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DateSerializationHandler
implements SerializationHandler {
    private Date value = null;
    private Calendar calendar;
    private ISO8601Format df;

    public DateSerializationHandler(TimeZone timeZone) {
        this.calendar = Calendar.getInstance(timeZone);
        this.df = new ISO8601Format(ISO8601Format.DATETIME_FORMAT_NO_TZ);
    }

    @Override
    public void fetchData(ResultSet rs, int column) throws SQLException {
        this.value = rs.getDate(column, this.calendar);
        if (this.value != null) {
            this.calendar.setTime(this.value);
        }
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void pushData(ContentHandler handler) throws SAXException {
        String s = this.df.format((Object)this.calendar);
        handler.characters(s.toCharArray(), 0, s.length());
    }
}

