/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.DataTypeNotSupportedException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.AbstrDialectSupport;
import org.clazzes.jdbc2xml.schema.impl.ColumnHelper;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.DropColumnCommand;
import org.clazzes.jdbc2xml.schema.impl.DropTableCommand;
import org.clazzes.jdbc2xml.sql.SimpleSqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommandQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDialect
extends AbstrDialectSupport {
    private static final Logger log = LoggerFactory.getLogger(MySQLDialect.class);
    public static final String defaultDriverName = "com.mysql.jdbc.Driver";
    private static final String createTableSuffix = "ENGINE=InnoDB DEFAULT CHARSET=utf8";
    private static final String addColumnCommand = "ADD COLUMN";
    public static final String UNQUOTE_DEFAULT_VALUES_PROPERTY = "unquoteDefaultValues";

    protected boolean isUnquoteDefaultValues() {
        String unquoteDefaultValues_s = this.getProperty(UNQUOTE_DEFAULT_VALUES_PROPERTY);
        return unquoteDefaultValues_s == null ? false : Boolean.parseBoolean(unquoteDefaultValues_s);
    }

    @Override
    public String getID() {
        return "MYSQL_5";
    }

    private String buildCreateTable(TableInfo ti) {
        return DDLHelper.buildCreateTable(ti, this, createTableSuffix);
    }

    @Override
    public void pushCreateTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti) {
        queue.pushCommand(this.buildCreateTable(ti), DDLHelper.buildDropTable(ti.getName()));
    }

    @Override
    public void pushRenameTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, String newTableName) throws SQLException {
        queue.pushCommand(DDLHelper.buildRenameTable(null, ti.getName(), newTableName));
    }

    @Override
    public void pushDropTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, boolean force) {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropTable(ti.getName()), null);
        } else {
            queue.pushCommand(new DropTableCommand(schemaEngine, ti, null, this));
        }
    }

    @Override
    public String createColumnSpec(ColumnInfo columnInfo) {
        StringBuffer columnSpec = new StringBuffer();
        columnSpec.append(columnInfo.getName());
        columnSpec.append(" ");
        switch (columnInfo.getType()) {
            case -5: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("BIGINT");
                    break;
                }
                columnSpec.append("BIGINT(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -2: {
                if (columnInfo.getPrecision() == null) {
                    return null;
                }
                columnSpec.append("BINARY(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -7: {
                if (columnInfo.getPrecision() == null || columnInfo.getPrecision() == 1) {
                    columnSpec.append("BOOL");
                    break;
                }
                columnSpec.append("BIT(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 16: {
                columnSpec.append("BOOL");
                break;
            }
            case -15: 
            case 1: {
                if (columnInfo.getPrecision() == null) {
                    return null;
                }
                columnSpec.append("CHAR(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 91: {
                columnSpec.append("DATE");
                break;
            }
            case 3: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("DECIMAL");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    columnSpec.append("DECIMAL(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                columnSpec.append("DECIMAL(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 8: {
                columnSpec.append("DOUBLE");
                break;
            }
            case 6: {
                columnSpec.append("FLOAT");
                break;
            }
            case 4: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("INT");
                    break;
                }
                columnSpec.append("INT(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -4: 
            case 2004: {
                if (columnInfo.getPrecision() == null || columnInfo.getPrecision() > 16277215) {
                    columnSpec.append("LONGBLOB");
                    break;
                }
                if (columnInfo.getPrecision() > 65535) {
                    columnSpec.append("MEDIUMBLOB");
                    break;
                }
                columnSpec.append("BLOB");
                break;
            }
            case -16: 
            case -1: 
            case 2005: {
                if (columnInfo.getPrecision() == null || columnInfo.getPrecision() > 16277215) {
                    columnSpec.append("LONGTEXT");
                    break;
                }
                if (columnInfo.getPrecision() > 65535) {
                    columnSpec.append("MEDIUMTEXT");
                    break;
                }
                columnSpec.append("TEXT");
                break;
            }
            case 2: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NUMERIC");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    columnSpec.append("NUMERIC(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                columnSpec.append("NUMERIC(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 7: {
                columnSpec.append("REAL");
                break;
            }
            case 5: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("SMALLINT");
                    break;
                }
                columnSpec.append("SMALLINT(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 92: {
                columnSpec.append("TIME");
                break;
            }
            case 93: {
                columnSpec.append("TIMESTAMP");
                break;
            }
            case 2014: {
                log.warn("TIMESTAMP_WITH_TIMEZONE not directly supported by MySQL/MariaDB engine. Using TIMESTAMP instead.");
                columnSpec.append("TIMESTAMP");
                break;
            }
            case -6: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("TINYINT");
                    break;
                }
                columnSpec.append("TINYINT(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -3: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("VARBINARY");
                    break;
                }
                columnSpec.append("VARBINARY(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -9: 
            case 12: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("VARCHAR");
                    break;
                }
                columnSpec.append("VARCHAR(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            default: {
                throw new DataTypeNotSupportedException(columnInfo.getType());
            }
        }
        if (!columnInfo.isNullable()) {
            columnSpec.append(" NOT NULL");
        } else if (columnInfo.getType() == 93) {
            columnSpec.append(" NULL");
        }
        if (columnInfo.getDefaultValue() != null) {
            columnSpec.append(" default ");
            if (TypesHelper.isNumeric(columnInfo.getType())) {
                columnSpec.append(columnInfo.getDefaultValue());
            } else {
                columnSpec.append('\'');
                this.quoteString(columnSpec, columnInfo.getDefaultValue());
                columnSpec.append('\'');
            }
        }
        if (columnInfo.isAutoIncrement()) {
            columnSpec.append(" AUTO_INCREMENT ");
        }
        return columnSpec.toString();
    }

    @Override
    public String defaultDriverName() {
        return defaultDriverName;
    }

    @Override
    public void quoteString(StringBuffer sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u0000') {
                sb.append("\\0");
                continue;
            }
            if (c == '\'' || c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    @Override
    public String normalizeDefaultValue(int type, String s) {
        if (type == -7 && s != null && s.startsWith("b'") && s.endsWith("'")) {
            return s.substring(2, s.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug("normalizeDefaultValue: {}", (Object)s);
        }
        if (this.isUnquoteDefaultValues()) {
            if (s == null || "NULL".equals(s)) {
                return null;
            }
            if (!TypesHelper.isNumeric(type) && s != null && s.startsWith("'") && s.endsWith("'")) {
                StringBuffer ret = new StringBuffer(s.length());
                for (int i = 1; i < s.length() - 1; ++i) {
                    int c = s.charAt(i);
                    if ((c == 39 || c == 92) && ++i < s.length() - 1) {
                        int c2 = s.charAt(i);
                        c = c == 92 ? (c2 == 110 ? 10 : (c2 == 114 ? 13 : (c2 == 116 ? 9 : c2))) : c2;
                    }
                    ret.append((char)c);
                }
                return ret.toString();
            }
        }
        return s;
    }

    private static String buildDropForeignKey(TableInfo ti, ForeignKeyInfo fki) {
        return DDLHelper.buildDropForeignKey(ti.getName(), fki.getName(), "DROP FOREIGN KEY");
    }

    @Override
    public void pushAddForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(new AddForeignKeyCommand(ti, fki));
    }

    @Override
    public void pushDropForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(new DropForeignKeyCommand(ti, fki));
    }

    private static String buildAddIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildAddIndex(ti, indexInfo, true, false);
    }

    private static String buildDropIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildDropIndex(ti.getName(), indexInfo.getName(), true);
    }

    @Override
    public void pushAddIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(MySQLDialect.buildAddIndex(ti, indexInfo), MySQLDialect.buildDropIndex(ti, indexInfo));
    }

    @Override
    public void pushDropIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(MySQLDialect.buildDropIndex(ti, indexInfo), MySQLDialect.buildAddIndex(ti, indexInfo));
    }

    private String buildAddColumn(TableInfo ti, ColumnInfo ci) {
        return DDLHelper.buildAddColumn(ti.getName(), ci, this, addColumnCommand, false);
    }

    @Override
    public void pushAddColumn(SqlCommandQueue queue, TableInfo ti, ColumnInfo ci) throws SQLException {
        queue.pushCommand(this.buildAddColumn(ti, ci), DDLHelper.buildDropColumn(ti.getName(), ci.getName()));
    }

    @Override
    public void pushDropColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo ci, boolean force) throws SQLException {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropColumn(ti.getName(), ci.getName()), this.buildAddColumn(ti, ci));
        } else if (!ci.isNullable()) {
            ColumnInfo ciNull = ColumnHelper.adaptNullability(ci, true);
            this.pushModifyColumn(schemaEngine, queue, ti, ci, ciNull);
            queue.pushCommand(new DropColumnCommand(schemaEngine, ti, ciNull, this, null, addColumnCommand, false));
        } else {
            queue.pushCommand(new DropColumnCommand(schemaEngine, ti, ci, this, createTableSuffix, addColumnCommand, false));
        }
    }

    private String buildChangeColumn(TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(ti.getName());
        sql.append(' ');
        sql.append("CHANGE COLUMN ");
        sql.append(oldColumnInfo.getName());
        sql.append(' ');
        sql.append(this.createColumnSpec(newColumnInfo));
        return sql.toString();
    }

    @Override
    public void pushChangeColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        queue.pushCommand(this.buildChangeColumn(ti, oldColumnInfo, newColumnInfo), this.buildChangeColumn(ti, newColumnInfo, oldColumnInfo));
    }

    private String buildModifyColumn(TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(ti.getName());
        sql.append(' ');
        sql.append("MODIFY COLUMN ");
        sql.append(this.createColumnSpec(newColumnInfo));
        return sql.toString();
    }

    @Override
    public void pushModifyColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        queue.pushCommand(this.buildModifyColumn(ti, oldColumnInfo, newColumnInfo), this.buildModifyColumn(ti, newColumnInfo, oldColumnInfo));
    }

    protected String getUrlScheme() {
        return "jdbc:mysql";
    }

    @Override
    public String constructJDBCURL(String hostname, Integer port, String databaseName, Properties properties) {
        StringBuffer url = new StringBuffer(this.getUrlScheme());
        url.append("://");
        if (hostname != null && hostname.length() > 0) {
            url.append(hostname);
        } else {
            url.append("localhost");
        }
        url.append(':');
        if (port != null && port > 0) {
            url.append(port);
        } else {
            url.append("3306");
        }
        if (databaseName != null && databaseName.length() > 0) {
            url.append("/");
            url.append(databaseName);
        }
        if (properties != null && properties.size() > 0) {
            int paramSep = 63;
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.toString();
                String propertyValue = properties.getProperty(propertyName);
                url.append((char)paramSep);
                paramSep = 38;
                url.append(propertyName);
                url.append('=');
                url.append(propertyValue);
            }
        }
        return url.toString();
    }

    @Override
    public int getMappedSqlType(String dialectDataType) {
        switch (dialectDataType = dialectDataType.toUpperCase().replace(" ", "_").trim()) {
            case "TIMESTAMP": {
                return 93;
            }
        }
        throw new DataTypeNotSupportedException(dialectDataType);
    }

    @Override
    public void fetchAdditionalColumnInfo(ISchemaEngine schemaEngine, TableInfo ti, ColumnInfo ci) {
    }

    private static class AddForeignKeyCommand
    extends SimpleSqlCommand {
        private final String dropKey;

        public AddForeignKeyCommand(TableInfo ti, ForeignKeyInfo fki) throws SQLException {
            super(DDLHelper.buildAddForeignKey(ti.getName(), fki, false), MySQLDialect.buildDropForeignKey(ti, fki));
            this.dropKey = DDLHelper.buildDropIndex(ti.getName(), fki.getName(), true);
        }

        @Override
        public void rollback(Connection connection) throws SQLException {
            super.rollback(connection);
            if (log.isDebugEnabled()) {
                log.debug("Running rollback statement [" + this.dropKey + "].");
            }
            try {
                SQLHelper.executeUpdate(connection, this.dropKey);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1091) {
                    if (log.isDebugEnabled()) {
                        log.debug("SQL error 1091 dropping backing index through command [" + this.dropKey + "] during rollback of add foreign key.");
                    }
                }
                throw e;
            }
        }
    }

    private static class DropForeignKeyCommand
    extends SimpleSqlCommand {
        private final String dropKey;

        public DropForeignKeyCommand(TableInfo ti, ForeignKeyInfo fki) throws SQLException {
            super(MySQLDialect.buildDropForeignKey(ti, fki), DDLHelper.buildAddForeignKey(ti.getName(), fki, false));
            this.dropKey = DDLHelper.buildDropIndex(ti.getName(), fki.getName(), true);
        }

        @Override
        public void perform(Connection connection) throws SQLException {
            super.perform(connection);
            if (log.isDebugEnabled()) {
                log.debug("Running [" + this.dropKey + "].");
            }
            try {
                SQLHelper.executeUpdate(connection, this.dropKey);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1091) {
                    if (log.isDebugEnabled()) {
                        log.debug("SQL error 1091 dropping backing index through command [" + this.dropKey + "].");
                    }
                }
                throw e;
            }
        }
    }
}

