/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.DataTypeNotSupportedException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.AbstrDialectSupport;
import org.clazzes.jdbc2xml.schema.impl.ColumnHelper;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.DropColumnCommand;
import org.clazzes.jdbc2xml.schema.impl.DropTableCommand;
import org.clazzes.jdbc2xml.sql.SqlCommandQueue;
import org.clazzes.util.lang.Util;

public class DerbyDialect
extends AbstrDialectSupport {
    public static final String defaultDriverName = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String addColumnCommand = "ADD COLUMN";
    private static final String BINARY_SUFFIX = " FOR BIT DATA";

    @Override
    public String getID() {
        return "Derby_10";
    }

    @Override
    public void pushCreateTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti) {
        queue.pushCommand(DDLHelper.buildCreateTable(ti, this, null), DDLHelper.buildDropTable(ti.getName()));
    }

    @Override
    public void pushRenameTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, String newTableName) throws SQLException {
        queue.pushCommand(DDLHelper.buildRenameTable(null, ti.getName(), newTableName));
    }

    @Override
    public void pushDropTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, boolean force) {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropTable(ti.getName()), null);
        } else {
            queue.pushCommand(new DropTableCommand(schemaEngine, ti, null, this));
        }
    }

    private static StringBuffer appendColumnType(StringBuffer columnSpec, ColumnInfo columnInfo) {
        switch (columnInfo.getType()) {
            case -5: {
                columnSpec.append("BIGINT");
                break;
            }
            case -7: 
            case -2: {
                SQLHelper.appendTypePrec(columnSpec, "CHAR", columnInfo.getPrecision());
                columnSpec.append(BINARY_SUFFIX);
                break;
            }
            case 2004: {
                SQLHelper.appendTypePrec(columnSpec, "BLOB", columnInfo.getPrecision());
                break;
            }
            case 16: {
                columnSpec.append("SMALLINT");
                break;
            }
            case -15: 
            case 1: {
                SQLHelper.appendTypePrec(columnSpec, "CHAR", columnInfo.getPrecision());
                break;
            }
            case 2005: {
                SQLHelper.appendTypePrec(columnSpec, "CLOB", columnInfo.getPrecision());
                break;
            }
            case 91: {
                columnSpec.append("DATE");
                break;
            }
            case 3: {
                SQLHelper.appendTypePrecScale(columnSpec, "DECIMAL", columnInfo.getPrecision(), columnInfo.getScale());
                break;
            }
            case 6: 
            case 8: {
                columnSpec.append("DOUBLE");
                break;
            }
            case 4: {
                columnSpec.append("INTEGER");
                break;
            }
            case -4: {
                if (columnInfo.getPrecision() == null || columnInfo.getPrecision() <= 32700) {
                    columnSpec.append("LONG VARCHAR");
                    columnSpec.append(BINARY_SUFFIX);
                    break;
                }
                SQLHelper.appendTypePrec(columnSpec, "BLOB", columnInfo.getPrecision());
                break;
            }
            case -16: 
            case -1: {
                if (columnInfo.getPrecision() == null || columnInfo.getPrecision() <= 32700) {
                    columnSpec.append("LONG VARCHAR");
                    break;
                }
                SQLHelper.appendTypePrec(columnSpec, "CLOB", columnInfo.getPrecision());
                break;
            }
            case 2: {
                SQLHelper.appendTypePrecScale(columnSpec, "NUMERIC", columnInfo.getPrecision(), columnInfo.getScale());
                break;
            }
            case 7: {
                columnSpec.append("REAL");
                break;
            }
            case 5: {
                columnSpec.append("SMALLINT");
                break;
            }
            case 92: {
                columnSpec.append("TIME");
                break;
            }
            case 93: 
            case 2014: {
                columnSpec.append("TIMESTAMP");
                break;
            }
            case -6: {
                columnSpec.append("SMALLINT");
                break;
            }
            case -3: {
                SQLHelper.appendTypePrec(columnSpec, "VARCHAR", columnInfo.getPrecision());
                columnSpec.append(BINARY_SUFFIX);
                break;
            }
            case -9: 
            case 12: {
                SQLHelper.appendTypePrec(columnSpec, "VARCHAR", columnInfo.getPrecision());
                break;
            }
            default: {
                throw new DataTypeNotSupportedException(columnInfo.getType());
            }
        }
        return columnSpec;
    }

    private void appendDefaultValue(StringBuffer columnSpec, ColumnInfo columnInfo) {
        if (columnInfo.getDefaultValue() != null) {
            columnSpec.append(" DEFAULT ");
            if (TypesHelper.isNumeric(columnInfo.getType())) {
                columnSpec.append(columnInfo.getDefaultValue());
            } else {
                columnSpec.append('\'');
                this.quoteString(columnSpec, columnInfo.getDefaultValue());
                columnSpec.append('\'');
            }
        }
    }

    @Override
    public String createColumnSpec(ColumnInfo columnInfo) {
        StringBuffer columnSpec = new StringBuffer();
        columnSpec.append(columnInfo.getName());
        columnSpec.append(" ");
        if (DerbyDialect.appendColumnType(columnSpec, columnInfo) == null) {
            return null;
        }
        if (!columnInfo.isNullable()) {
            columnSpec.append(" NOT NULL");
        }
        this.appendDefaultValue(columnSpec, columnInfo);
        if (columnInfo.isAutoIncrement()) {
            columnSpec.append(" GENERATED BY DEFAULT AS IDENTITY");
        }
        return columnSpec.toString();
    }

    @Override
    public String defaultDriverName() {
        return defaultDriverName;
    }

    @Override
    public void quoteString(StringBuffer sb, String s) {
        SQLHelper.quoteISOSqlString(sb, s);
    }

    @Override
    public String normalizeDefaultValue(int type, String s) {
        if (s == null || "GENERATED_BY_DEFAULT".equals(s)) {
            return null;
        }
        if (!TypesHelper.isNumeric(type) && s.startsWith("'") && s.endsWith("'") && s.length() > 2) {
            return s.substring(1, s.length() - 1).replace("''", "'");
        }
        return s;
    }

    private static String buildDropForeignKey(TableInfo ti, ForeignKeyInfo fki) {
        return DDLHelper.buildDropForeignKey(ti.getName(), fki.getName(), "DROP FOREIGN KEY");
    }

    @Override
    public void pushAddForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(DDLHelper.buildAddForeignKey(ti.getName(), fki, false), DerbyDialect.buildDropForeignKey(ti, fki));
    }

    @Override
    public void pushDropForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(DerbyDialect.buildDropForeignKey(ti, fki), DDLHelper.buildAddForeignKey(ti.getName(), fki, false));
    }

    private static String buildAddIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildAddIndex(ti, indexInfo, false, false);
    }

    private static String buildDropIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildDropIndex(ti.getName(), indexInfo.getName(), false);
    }

    @Override
    public void pushAddIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(DerbyDialect.buildAddIndex(ti, indexInfo), DerbyDialect.buildDropIndex(ti, indexInfo));
    }

    @Override
    public void pushDropIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(DerbyDialect.buildDropIndex(ti, indexInfo), DerbyDialect.buildAddIndex(ti, indexInfo));
    }

    private String buildAddColumn(TableInfo ti, ColumnInfo ci) {
        return DDLHelper.buildAddColumn(ti.getName(), ci, this, addColumnCommand, false);
    }

    @Override
    public void pushAddColumn(SqlCommandQueue queue, TableInfo ti, ColumnInfo ci) throws SQLException {
        queue.pushCommand(this.buildAddColumn(ti, ci), DDLHelper.buildDropColumn(ti.getName(), ci.getName()));
    }

    @Override
    public void pushDropColumn(ISchemaEngine schema, SqlCommandQueue queue, TableInfo ti, ColumnInfo ci, boolean force) throws SQLException {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropColumn(ti.getName(), ci.getName()), this.buildAddColumn(ti, ci));
        } else if (!ci.isNullable()) {
            ColumnInfo ciNull = ColumnHelper.adaptNullability(ci, true);
            DerbyDialect.pushAdaptNullability(queue, ti, ci, ciNull);
            queue.pushCommand(new DropColumnCommand(schema, ti, ciNull, this, null, addColumnCommand, false));
        } else {
            queue.pushCommand(new DropColumnCommand(schema, ti, ci, this, null, addColumnCommand, false));
        }
    }

    private static String buildAdaptNullability(String tableName, ColumnInfo columnInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(' ');
        sql.append("ALTER COLUMN ");
        sql.append(columnInfo.getName());
        if (columnInfo.isNullable()) {
            sql.append(" NULL");
        } else {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    private static void pushAdaptNullability(SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        if (oldColumnInfo.isNullable() == newColumnInfo.isNullable()) {
            return;
        }
        queue.pushCommand(DerbyDialect.buildAdaptNullability(ti.getName(), newColumnInfo), DerbyDialect.buildAdaptNullability(ti.getName(), oldColumnInfo));
    }

    private static String buildAdaptDefaultValue(String tableName, ColumnInfo columnInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(' ');
        sql.append("ALTER COLUMN ");
        sql.append(columnInfo.getName());
        if (columnInfo.isNullable()) {
            sql.append(" NULL");
        } else {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    private static void pushAdaptDefaultValue(SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) {
        if (Util.equalsNullAware((Object)oldColumnInfo.getDefaultValue(), (Object)newColumnInfo.getDefaultValue())) {
            return;
        }
        queue.pushCommand(DerbyDialect.buildAdaptDefaultValue(ti.getName(), newColumnInfo), DerbyDialect.buildAdaptDefaultValue(ti.getName(), oldColumnInfo));
    }

    private void pushAdaptNullabilityAndDefaultValue(SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        ColumnInfo tmpInfo = ColumnHelper.adaptNullability(newColumnInfo, oldColumnInfo.isNullable());
        DerbyDialect.pushAdaptDefaultValue(queue, ti, oldColumnInfo, tmpInfo);
        DerbyDialect.pushAdaptNullability(queue, ti, tmpInfo, newColumnInfo);
    }

    private void pushCreateCopyDrop(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        ColumnInfo tmpInfo = ColumnHelper.adaptNullability(newColumnInfo, true);
        this.pushAddColumn(queue, ti, tmpInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(ti.getName());
        sql.append(" SET ");
        sql.append(newColumnInfo.getName());
        sql.append(" = ");
        sql.append(oldColumnInfo.getName());
        StringBuffer rsql = new StringBuffer();
        rsql.append("UPDATE ");
        rsql.append(ti.getName());
        rsql.append(" SET ");
        rsql.append(newColumnInfo.getName());
        rsql.append(" = NULL");
        queue.pushCommand(sql.toString(), rsql.toString());
        sql.delete(0, sql.length());
        rsql.delete(0, rsql.length());
        if (!newColumnInfo.isNullable()) {
            DerbyDialect.pushAdaptNullability(queue, ti, tmpInfo, newColumnInfo);
        }
        this.pushDropColumn(schemaEngine, queue, ti, oldColumnInfo, true);
    }

    private static String buildRenameColumn(String tableName, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("RENAME COLUMN ");
        sql.append(tableName);
        sql.append('.');
        sql.append(oldColumnInfo.getName());
        sql.append(" TO ");
        sql.append(newColumnInfo.getName());
        return sql.toString();
    }

    private void pushRename(SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        queue.pushCommand(DerbyDialect.buildRenameColumn(ti.getName(), oldColumnInfo, newColumnInfo), DerbyDialect.buildRenameColumn(ti.getName(), newColumnInfo, oldColumnInfo));
    }

    @Override
    public void pushChangeColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        if (oldColumnInfo.getType() == newColumnInfo.getType() && Util.equalsNullAware((Object)oldColumnInfo.getPrecision(), (Object)newColumnInfo.getPrecision()) && Util.equalsNullAware((Object)oldColumnInfo.getScale(), (Object)newColumnInfo.getScale())) {
            ColumnInfo tmpInfo = ColumnHelper.rename(oldColumnInfo, newColumnInfo.getName());
            this.pushRename(queue, ti, oldColumnInfo, tmpInfo);
            this.pushAdaptNullabilityAndDefaultValue(queue, ti, tmpInfo, newColumnInfo);
            return;
        }
        this.pushCreateCopyDrop(schemaEngine, queue, ti, oldColumnInfo, newColumnInfo);
    }

    @Override
    public void pushModifyColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        if (oldColumnInfo.getType() == newColumnInfo.getType() && Util.equalsNullAware((Object)oldColumnInfo.getPrecision(), (Object)newColumnInfo.getPrecision()) && Util.equalsNullAware((Object)oldColumnInfo.getScale(), (Object)newColumnInfo.getScale())) {
            this.pushAdaptNullabilityAndDefaultValue(queue, ti, oldColumnInfo, newColumnInfo);
            return;
        }
        ColumnInfo tmpInfo = ColumnHelper.rename(oldColumnInfo, newColumnInfo.getName() + "__DUP");
        this.pushRename(queue, ti, oldColumnInfo, tmpInfo);
        this.pushCreateCopyDrop(schemaEngine, queue, ti, tmpInfo, newColumnInfo);
    }

    @Override
    public String constructJDBCURL(String hostname, Integer port, String databaseName, Properties properties) {
        StringBuffer url = new StringBuffer("jdbc:derby:");
        if (hostname != null && hostname.length() > 0 || port != null && port > 0) {
            url.append("//");
            if (hostname != null && hostname.length() > 0) {
                url.append(hostname);
            } else {
                url.append("localhost");
            }
            url.append(':');
            if (port != null && port > 0) {
                url.append(port);
            } else {
                url.append("1527");
            }
            url.append('/');
        }
        if (databaseName != null && databaseName.length() > 0) {
            url.append(databaseName);
        }
        if (properties != null && properties.size() > 0) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.toString();
                String propertyValue = properties.getProperty(propertyName);
                url.append(';');
                url.append(propertyName);
                url.append('=');
                url.append(propertyValue);
            }
        }
        return url.toString();
    }

    @Override
    public int getMappedSqlType(String dialectDataType) {
        String effectiveType;
        switch (effectiveType = dialectDataType.replace(' ', '_').replaceAll("\\(.*?\\)", "").trim()) {
            case "TIMESTAMP": {
                return 93;
            }
        }
        throw new DataTypeNotSupportedException(dialectDataType);
    }

    @Override
    public void fetchAdditionalColumnInfo(ISchemaEngine schemaEngine, TableInfo ti, ColumnInfo ci) {
    }
}

