/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.SQLException;
import java.util.List;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.sql.SimpleSqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommand;

public abstract class DDLHelper {
    public static String buildCreateTable(TableInfo ti, Dialect dialect, String suffix) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(ti.getName());
        List<ColumnInfo> columns = ti.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo ci = columns.get(i);
            if (i == 0) {
                sql.append(" (");
            } else {
                sql.append(" ,");
            }
            String columnSpec = dialect.createColumnSpec(ci);
            sql.append(columnSpec);
        }
        PrimaryKeyInfo pkInfo = ti.getPrimaryKey();
        if (pkInfo != null) {
            sql.append(" ,");
            if (pkInfo.getName() != null && pkInfo.getName().length() > 0) {
                sql.append("CONSTRAINT " + pkInfo.getName());
            }
            sql.append(" PRIMARY KEY ( ");
            JAVAHelper.joinStrings(sql, pkInfo.getColumns());
            sql.append(" )");
        }
        sql.append(" )");
        if (suffix != null) {
            sql.append(suffix);
        }
        return sql.toString();
    }

    public static String buildDropTable(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("DROP TABLE ");
        sql.append(tableName);
        return sql.toString();
    }

    public static String buildAddIndex(TableInfo ti, IndexInfo indexInfo, boolean allowsMultipleNullsInUniqueIndizes) throws SQLException {
        return DDLHelper.buildAddIndex(ti, indexInfo, allowsMultipleNullsInUniqueIndizes, false);
    }

    public static String buildAddIndex(TableInfo ti, IndexInfo indexInfo, boolean allowsMultipleNullsInUniqueIndizes, boolean allowsIncludeColumns) throws SQLException {
        boolean includeColumnsExists;
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        if (indexInfo.isUnique() && (allowsMultipleNullsInUniqueIndizes || !ti.indexContainsNullableColumns(indexInfo))) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        if (indexInfo.getName() == null || indexInfo.getName().length() == 0) {
            throw new SQLException("doAddIndexInfo: All indices must have non-null and non-empty names");
        }
        sql.append(indexInfo.getName());
        sql.append(" ON ");
        sql.append(ti.getName());
        sql.append(" ( ");
        JAVAHelper.joinStrings(sql, indexInfo.getColumns());
        sql.append(" )");
        boolean bl = includeColumnsExists = indexInfo.getIncludeColumns() != null && !indexInfo.getIncludeColumns().isEmpty();
        if (allowsIncludeColumns && includeColumnsExists) {
            sql.append(" INCLUDE ( ");
            JAVAHelper.joinStrings(sql, indexInfo.getIncludeColumns());
            sql.append(" )");
        }
        return sql.toString();
    }

    public static String buildDropIndex(String tableName, String indexName, boolean needsOnTableSuffix) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DROP INDEX ");
        if (indexName == null || indexName.length() == 0) {
            throw new SQLException("dropIndex: Indices have non-null and non-empty names");
        }
        sql.append(indexName);
        if (needsOnTableSuffix) {
            sql.append(" ON ");
            sql.append(tableName);
        }
        return sql.toString();
    }

    public static String buildAddForeignKey(String tableName, ForeignKeyInfo foreignKeyInfo, boolean addStmtInBrackets) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" ADD ");
        if (addStmtInBrackets) {
            sql.append("(");
        }
        if (foreignKeyInfo.getName() != null && foreignKeyInfo.getName().length() > 0) {
            sql.append(" CONSTRAINT " + foreignKeyInfo.getName());
        }
        sql.append(" FOREIGN KEY ( ");
        JAVAHelper.joinStrings(sql, foreignKeyInfo.getColumns());
        sql.append(" ) REFERENCES ");
        sql.append(foreignKeyInfo.getForeignTable());
        sql.append(" ( ");
        JAVAHelper.joinStrings(sql, foreignKeyInfo.getForeignColumns());
        sql.append(" )");
        switch (foreignKeyInfo.getDeleteRule()) {
            case 0: {
                sql.append(" ON DELETE CASCADE");
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                sql.append(" ON DELETE SET DEFAULT");
                break;
            }
            case 2: {
                sql.append(" ON DELETE SET NULL");
            }
        }
        switch (foreignKeyInfo.getUpdateRule()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                sql.append(" ON UPDATE SET DEFAULT");
                break;
            }
            case 2: {
                sql.append(" ON UPDATE SET NULL");
            }
        }
        if (foreignKeyInfo.getDeferrability() != 7) {
            throw new SQLException("foreign key deferrability is not implemented yet.");
        }
        if (addStmtInBrackets) {
            sql.append(")");
        }
        return sql.toString();
    }

    public static String buildDropForeignKey(String tableName, String foreignKeyName, String dropForeignKeyCommand) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(' ');
        sql.append(dropForeignKeyCommand);
        sql.append(' ');
        sql.append(foreignKeyName);
        return sql.toString();
    }

    public static String buildAddColumn(String tableName, ColumnInfo ci, Dialect dialect, String addColumnCommand, boolean addStmtInBrackets) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" ");
        sql.append(addColumnCommand);
        if (addStmtInBrackets) {
            sql.append(" ( ");
        } else {
            sql.append(" ");
        }
        sql.append(dialect.createColumnSpec(ci));
        if (addStmtInBrackets) {
            sql.append(" )");
        }
        return sql.toString();
    }

    public static String buildDropColumn(String tableName, String columnName) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" ");
        sql.append("DROP COLUMN ");
        sql.append(columnName);
        return sql.toString();
    }

    public static SqlCommand buildRenameTable(String renameTableCommand, String tableName, String newTableName) {
        if (renameTableCommand == null) {
            renameTableCommand = "RENAME TABLE %s TO %s";
        }
        return new SimpleSqlCommand(String.format(renameTableCommand, tableName, newTableName), String.format(renameTableCommand, newTableName, tableName));
    }

    public static String buildHexSuffix() {
        return Long.toHexString(System.currentTimeMillis() * 479001599L & 0xFFFFFFFFL);
    }
}

