/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.SortableTableDescription;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableSorter {
    private static Logger log = LoggerFactory.getLogger(TableSorter.class);

    private static void getFKDepthRecursive(Map<String, SortableTableDescription> tablesByName, SortableTableDescription si) {
        si.setFkDepth(0);
        if (si.getTableInfo().getForeignKeys() != null) {
            for (ForeignKeyInfo fkInfo : si.getTableInfo().getForeignKeys()) {
                int fDepth;
                SortableTableDescription foreignSi;
                if (fkInfo.getForeignTable().equalsIgnoreCase(si.getTableInfo().getName()) || (foreignSi = tablesByName.get(fkInfo.getForeignTable())) == null) continue;
                if (foreignSi.getFkDepth() < 0) {
                    TableSorter.getFKDepthRecursive(tablesByName, foreignSi);
                }
                if ((fDepth = foreignSi.getFkDepth() + 1) <= si.getFkDepth()) continue;
                si.setFkDepth(fDepth);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Table [" + si.getTableInfo().getName() + "] has a foreign key depth of [" + si.getFkDepth() + "].");
        }
    }

    public static void sortTablesByFKDepth(List<? extends SortableTableDescription> tables) {
        HashMap<String, SortableTableDescription> tablesByName = new HashMap<String, SortableTableDescription>(tables.size());
        for (SortableTableDescription sortableTableDescription : tables) {
            sortableTableDescription.setFkDepth(-1);
            if (sortableTableDescription.getTableInfo() == null) continue;
            tablesByName.put(sortableTableDescription.getTableInfo().getName(), sortableTableDescription);
        }
        for (SortableTableDescription sortableTableDescription : tables) {
            TableInfo ti = sortableTableDescription.getTableInfo();
            if (ti == null) {
                sortableTableDescription.setFkDepth(Integer.MAX_VALUE);
                continue;
            }
            if (sortableTableDescription.getFkDepth() >= 0) continue;
            TableSorter.getFKDepthRecursive(tablesByName, sortableTableDescription);
        }
        Collections.sort(tables);
    }
}

