/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class IndexInfo {
    private String name;
    private List<String> columns;
    private List<String> includeColumns;
    private String filterCondition;
    private Order order;
    private boolean unique;

    public IndexInfo() {
    }

    public IndexInfo(String name, String columns, boolean unique, String filterCondition) {
        this.name = name;
        this.columns = JAVAHelper.splitString(columns);
        this.unique = unique;
        this.filterCondition = filterCondition;
    }

    public IndexInfo(String name, String columns, String includeColumns, boolean unique, String filterCondition) {
        this.name = name;
        this.columns = JAVAHelper.splitString(columns);
        this.includeColumns = JAVAHelper.splitString(includeColumns);
        this.unique = unique;
        this.filterCondition = filterCondition;
    }

    public IndexInfo(Attributes atts) {
        this.name = atts.getValue("name");
        this.filterCondition = atts.getValue("filterCondition");
        String unique_s = atts.getValue("unique");
        this.unique = unique_s == null ? false : Boolean.parseBoolean(unique_s);
        String order_s = atts.getValue("order");
        this.order = order_s == null ? null : Order.valueOf(order_s);
        String col_s = atts.getValue("columns");
        this.columns = col_s == null ? null : JAVAHelper.splitString(col_s);
        String includeColumns_s = atts.getValue("includeColumns");
        this.includeColumns = includeColumns_s == null ? null : JAVAHelper.splitString(includeColumns_s);
    }

    public Attributes toAttributes(SqlIdentifierMapper mapper) {
        AttributesImpl atts = new AttributesImpl();
        if (this.name != null) {
            atts.addAttribute("", "", "name", "CDATA", mapper.toExternal(this.name));
        }
        if (this.filterCondition != null) {
            atts.addAttribute("", "", "filterCondition", "CDATA", mapper.toExternal(this.filterCondition));
        }
        if (this.order != null) {
            atts.addAttribute("", "", "order", "CDATA", this.order.toString());
        }
        atts.addAttribute("", "", "unique", "CDATA", Boolean.toString(this.unique));
        if (this.columns != null) {
            atts.addAttribute("", "", "columns", "CDATA", SQLHelper.joinIdentifiers(this.columns, mapper));
        }
        if (this.includeColumns != null) {
            atts.addAttribute("", "", "includeColumns", "CDATA", SQLHelper.joinIdentifiers(this.includeColumns, mapper));
        }
        return atts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void addColumn(String column) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(column);
    }

    public List<String> getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(List<String> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public void addIncludeColumn(String includeColumn) {
        if (this.includeColumns == null) {
            this.includeColumns = new ArrayList<String>();
        }
        this.includeColumns.add(includeColumn);
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public String toString() {
        return "IndexInfo{" + (this.unique ? "UNIQUE " : "") + "name='" + this.name + "', columns=" + String.valueOf(this.columns) + ", includeColumns=" + String.valueOf(this.includeColumns) + ", filterCondition='" + this.filterCondition + "', order=" + String.valueOf((Object)this.order) + "}";
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

