/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ForeignKeyInfo {
    private String name;
    private List<String> columns;
    private String pkName;
    private String foreignTable;
    private List<String> foreignColumns;
    private short updateRule;
    private short deleteRule;
    private short deferrability;

    public ForeignKeyInfo() {
        this.deferrability = (short)7;
        this.deleteRule = (short)3;
        this.updateRule = (short)3;
    }

    public ForeignKeyInfo(String name, String columns, String foreignTable, String foreignColumns) {
        this.name = name;
        this.columns = JAVAHelper.splitString(columns);
        this.foreignTable = foreignTable;
        this.foreignColumns = JAVAHelper.splitString(foreignColumns);
        this.deferrability = (short)7;
        this.deleteRule = (short)3;
        this.updateRule = (short)3;
    }

    public ForeignKeyInfo(Attributes atts) {
        this.name = atts.getValue("name");
        this.pkName = atts.getValue("pkName");
        this.foreignTable = atts.getValue("foreignTable");
        this.deleteRule = TypesHelper.fkRuleStringToShort(atts.getValue("deleteRule"));
        this.updateRule = TypesHelper.fkRuleStringToShort(atts.getValue("updateRule"));
        this.deferrability = TypesHelper.deferrabilityStringToShort(atts.getValue("deferrability"));
        String col_s = atts.getValue("columns");
        this.columns = col_s == null ? null : JAVAHelper.splitString(col_s);
        col_s = atts.getValue("foreignColumns");
        this.foreignColumns = col_s == null ? null : JAVAHelper.splitString(col_s);
    }

    public Attributes toAttributes(SqlIdentifierMapper mapper) {
        AttributesImpl atts = new AttributesImpl();
        if (this.name != null) {
            atts.addAttribute("", "", "name", "CDATA", mapper.toExternal(this.name));
        }
        if (this.pkName != null) {
            atts.addAttribute("", "", "pkName", "CDATA", mapper.toExternal(this.pkName));
        }
        if (this.foreignTable != null) {
            atts.addAttribute("", "", "foreignTable", "CDATA", mapper.toExternal(this.foreignTable));
        }
        atts.addAttribute("", "", "deleteRule", "CDATA", TypesHelper.fkRuleShortToString(this.deleteRule));
        atts.addAttribute("", "", "updateRule", "CDATA", TypesHelper.fkRuleShortToString(this.updateRule));
        atts.addAttribute("", "", "deferrability", "CDATA", TypesHelper.deferrabilityShortToString(this.deferrability));
        if (this.columns != null) {
            atts.addAttribute("", "", "columns", "CDATA", SQLHelper.joinIdentifiers(this.columns, mapper));
        }
        if (this.foreignColumns != null) {
            atts.addAttribute("", "", "foreignColumns", "CDATA", SQLHelper.joinIdentifiers(this.foreignColumns, mapper));
        }
        return atts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void addColumn(String column) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(column);
    }

    public String getPkName() {
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getForeignTable() {
        return this.foreignTable;
    }

    public void setForeignTable(String foreignTable) {
        this.foreignTable = foreignTable;
    }

    public List<String> getForeignColumns() {
        return this.foreignColumns;
    }

    public void setForeignColumns(List<String> foreignColumns) {
        this.foreignColumns = foreignColumns;
    }

    public void addForeignColumn(String column) {
        if (this.foreignColumns == null) {
            this.foreignColumns = new ArrayList<String>();
        }
        this.foreignColumns.add(column);
    }

    public short getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(short updateRule) {
        this.updateRule = updateRule;
    }

    public short getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(short deleteRule) {
        this.deleteRule = deleteRule;
    }

    public short getDeferrability() {
        return this.deferrability;
    }

    public void setDeferrability(short deferrability) {
        this.deferrability = deferrability;
    }

    public String toString() {
        return "ForeignKeyInfo{pkName='" + this.pkName + "', foreignTable='" + this.foreignTable + "', name='" + this.name + "'}";
    }
}

