/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ColumnInfo {
    private String name;
    private int type;
    private Integer precision;
    private Integer scale;
    private boolean nullable;
    private String defaultValue;
    private boolean autoIncrement;
    private Integer nextValue;

    public ColumnInfo(String name, int type, Integer precision, Integer scale, boolean nullable, String defaultValue, boolean autoIncrement) {
        this(name, type, precision, scale, nullable, defaultValue);
        this.autoIncrement = autoIncrement;
    }

    public ColumnInfo(String name, int type, Integer precision, Integer scale, boolean nullable, String defaultValue) {
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.autoIncrement = false;
    }

    public ColumnInfo(Attributes atts) throws SAXException {
        this.name = atts.getValue(Constants.COLUMN_TAG_NAME_ATT);
        if (this.name == null) {
            throw new SAXException("Column without a name attribute found.");
        }
        String type_s = atts.getValue(Constants.COLUMN_TAG_TYPE_ATT);
        this.type = type_s == null ? 12 : TypesHelper.stringToType(type_s);
        String prec_s = atts.getValue(Constants.COLUMN_TAG_PREC_ATT);
        this.precision = prec_s == null ? null : Integer.valueOf(prec_s);
        String scale_s = atts.getValue(Constants.COLUMN_TAG_SCALE_ATT);
        this.scale = scale_s == null ? null : Integer.valueOf(scale_s);
        String nullable_s = atts.getValue(Constants.COLUMN_TAG_NULLABLE_ATT);
        this.nullable = nullable_s == null ? true : Boolean.parseBoolean(nullable_s);
        String defValue = atts.getValue(Constants.COLUMN_TAG_DEFAULT_ATT);
        this.defaultValue = defValue == null ? null : defValue.replace("''", "'");
        String autoIncrement_s = atts.getValue(Constants.COLUMN_TAG_AUTOINCREMENT_ATT);
        this.autoIncrement = autoIncrement_s == null ? false : Boolean.parseBoolean(autoIncrement_s);
        String nextValue_s = atts.getValue(Constants.COLUMN_TAG_NEXTVALUE_ATT);
        this.nextValue = nextValue_s == null ? null : Integer.valueOf(nextValue_s);
    }

    public ColumnInfo(ResultSetMetaData md, int column) throws SQLException {
        this.name = md.getColumnName(column);
        this.type = md.getColumnType(column);
        int prec = md.getPrecision(column);
        this.precision = prec > 0 && this.type != 8 && this.type != 6 ? Integer.valueOf(prec) : null;
        this.scale = this.type == 2 || this.type == 3 || this.type == 7 ? Integer.valueOf(md.getScale(column)) : null;
        this.nullable = md.isNullable(column) != 0;
        this.defaultValue = null;
        this.autoIncrement = md.isAutoIncrement(column);
    }

    public Attributes toAttributes(SqlIdentifierMapper mapper) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", Constants.COLUMN_TAG_NAME_ATT, "CDATA", mapper.toExternal(this.getName()));
        atts.addAttribute("", "", Constants.COLUMN_TAG_TYPE_ATT, "CDATA", TypesHelper.typeToString(this.getType()));
        if (this.getPrecision() != null) {
            atts.addAttribute("", "", Constants.COLUMN_TAG_PREC_ATT, "CDATA", this.getPrecision().toString());
        }
        if (this.getScale() != null) {
            atts.addAttribute("", "", Constants.COLUMN_TAG_SCALE_ATT, "CDATA", this.getScale().toString());
        }
        atts.addAttribute("", "", Constants.COLUMN_TAG_NULLABLE_ATT, "CDATA", Boolean.toString(this.isNullable()));
        if (this.getDefaultValue() != null) {
            atts.addAttribute("", "", Constants.COLUMN_TAG_DEFAULT_ATT, "CDATA", this.getDefaultValue());
        }
        if (this.isAutoIncrement()) {
            atts.addAttribute("", "", Constants.COLUMN_TAG_AUTOINCREMENT_ATT, "CDATA", Boolean.toString(this.isAutoIncrement()));
        }
        if (this.isAutoIncrement() && this.nextValue != null) {
            atts.addAttribute("", "", Constants.COLUMN_TAG_NEXTVALUE_ATT, "CDATA", this.getNextValue().toString());
        }
        return atts;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setNextValue(int nextValue) {
        this.nextValue = nextValue;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public Integer getNextValue() {
        return this.nextValue;
    }

    public String toString() {
        return "ColumnInfo{name='" + this.getName() + "', type=" + this.getType() + "(" + this.getPrecision() + ")" + (this.isNullable() ? " NULLABLE" : "") + (this.isAutoIncrement() ? " AUTO_INC" : "") + "}";
    }
}

