/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.sax.XmlPretty;
import org.clazzes.jdbc2xml.sax.XmlPrettyConfig;
import org.clazzes.util.xml.XMLSerializerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ZipFileContentHandler
implements ContentHandler {
    private static final Logger log = LoggerFactory.getLogger(ZipFileContentHandler.class);
    private final String mainEntryName;
    private final ByteArrayOutputStream bos;
    private final Deque<ContentHandler> serializer;
    private ZipOutputStream os;
    private String currentTableName;
    private XmlPrettyConfig xmlPrettyConfig;

    public ZipFileContentHandler(ZipOutputStream os, String mainEntryName, XmlPrettyConfig prettyConfig) {
        this.os = os;
        this.mainEntryName = mainEntryName;
        this.xmlPrettyConfig = prettyConfig;
        this.bos = new ByteArrayOutputStream();
        this.serializer = new ArrayDeque<ContentHandler>();
        ContentHandler contentHandler = XMLSerializerHelper.newSerializer((OutputStream)this.bos);
        XmlPretty xmlPretty = new XmlPretty(contentHandler, this.xmlPrettyConfig);
        this.serializer.push(xmlPretty);
        if (log.isDebugEnabled()) {
            log.debug("ZipFileContentHandler instantiated: mainEntryName=[" + mainEntryName + "].");
        }
    }

    private ContentHandler getContentHandler() {
        return this.serializer.peek();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.getContentHandler().characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("endDocument: started ...");
        }
        this.getContentHandler().endDocument();
        if (this.serializer.size() == 1) {
            log.info("end of main Document detected, writing ZIP-Entry: [" + this.mainEntryName + "] ...");
            try {
                this.os.putNextEntry(new ZipEntry(this.mainEntryName));
                this.os.write(this.bos.toByteArray());
                this.bos.close();
                this.os.closeEntry();
                this.os.finish();
            }
            catch (IOException e) {
                String msg = "Error writing ZIP-File-Entry [" + this.mainEntryName + "].";
                log.error(msg, (Throwable)e);
                throw new SAXException(msg, e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("endDocument: finished.");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (Constants.ROWSET_TAG_NAME.equalsIgnoreCase(qName)) {
            this.getContentHandler().endElement(uri, localName, qName);
            this.getContentHandler().endPrefixMapping("");
            this.getContentHandler().endDocument();
            try {
                this.os.closeEntry();
                log.info("ZIP-File-Entry closed.");
                this.serializer.poll();
                this.getContentHandler().endElement(Constants.W3_XINCLUDE_NS_URI, Constants.INCLUDE_TAG_NAME, Constants.INCLUDE_TAG_NAME);
                return;
            }
            catch (IOException e) {
                String msg = "Error closing ZIP-File-Entry.";
                log.error("Error closing ZIP-File-Entry.", (Throwable)e);
                throw new SAXException("Error closing ZIP-File-Entry.", e);
            }
        }
        this.getContentHandler().endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.getContentHandler().endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.getContentHandler().ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.getContentHandler().processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.getContentHandler().setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.getContentHandler().skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        log.info("startDocument");
        if (this.os == null) {
            String msg = "Error startDocument: ZipOutputStream is null.";
            log.error("Error startDocument: ZipOutputStream is null.");
            throw new SAXException("Error startDocument: ZipOutputStream is null.");
        }
        this.getContentHandler().startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (Constants.TABLE_TAG_NAME.equalsIgnoreCase(qName)) {
            this.currentTableName = atts.getValue(Constants.TABLE_TAG_NAME_ATT);
            if (log.isDebugEnabled()) {
                log.debug("processing table: [" + this.currentTableName + "] ...");
            }
        } else if (Constants.ROWSET_TAG_NAME.equalsIgnoreCase(qName)) {
            ZipEntry entry = new ZipEntry(this.currentTableName + "_data.xml");
            log.info("Start new ZIP-File-Entry [" + entry.getName() + "] ...");
            AttributesImpl a = new AttributesImpl();
            a.addAttribute("", "", Constants.INCLUDE_REFERENCE_ATT, "CDATA", entry.getName());
            this.getContentHandler().startElement(Constants.W3_XINCLUDE_NS_URI, Constants.INCLUDE_TAG_NAME, Constants.INCLUDE_TAG_NAME, a);
            try {
                this.os.putNextEntry(entry);
                ContentHandler contentHandler = XMLSerializerHelper.newSerializer((OutputStream)this.os);
                XmlPretty xmlPretty = new XmlPretty(contentHandler, this.xmlPrettyConfig);
                this.serializer.push(xmlPretty);
                this.getContentHandler().startDocument();
                this.getContentHandler().startPrefixMapping("", Constants.JDBC2XML_NS_URI);
                this.getContentHandler().startElement(uri, localName, qName, atts);
                return;
            }
            catch (IOException e) {
                String msg = "Error adding new Entry [" + entry.getName() + "] to ZIP-File.";
                log.error(msg, (Throwable)e);
                throw new SAXException(msg, e);
            }
        }
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getContentHandler().startPrefixMapping(prefix, uri);
    }
}

