/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.sql.SQLException;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.sax.impl.ColumnSetTagHandler;
import org.clazzes.jdbc2xml.sax.impl.ForeignKeySetTagHandler;
import org.clazzes.jdbc2xml.sax.impl.IndexSetTagHandler;
import org.clazzes.jdbc2xml.sax.impl.InsertContext;
import org.clazzes.jdbc2xml.sax.impl.RowSetTagHandler;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TableTagHandler
implements SAXTagHandler {
    private static final Logger log = LoggerFactory.getLogger(TableTagHandler.class);
    private InsertContext context;
    private TableInfo tableInfo;
    private boolean tableCreated;

    private void createTable() throws SAXException {
        if (this.context.getProcessRestrictionFilter().isProcessSchema()) {
            try {
                this.context.getSchemaEngine().createTable(this.tableInfo, false);
            }
            catch (SQLException e) {
                throw new SAXException("SQL error creating table [" + this.tableInfo.getName() + "].", e);
            }
            this.context.addParsedTable(this.tableInfo);
        } else if (this.context.getProcessRestrictionFilter().isProcessConstraints()) {
            log.info("Adding table [" + this.tableInfo.getName() + "] for later constraint processing without creating it.");
            this.context.addParsedTable(this.tableInfo);
        } else {
            log.info("Not creating table [" + this.tableInfo.getName() + "] because schema processing is turned off.");
        }
        this.tableCreated = true;
    }

    public TableTagHandler(InsertContext context, Attributes atts) {
        this.context = context;
        this.tableInfo = new TableInfo(atts.getValue(Constants.TABLE_TAG_NAME_ATT));
        this.tableInfo.setComment(atts.getValue(Constants.TABLE_TAG_COMMENT_ATT));
        this.tableCreated = false;
        log.info("Parsing table [" + this.tableInfo.getName() + "]...");
    }

    public void closeTag(String uri, String localName, String name) throws SAXException {
        if (!this.tableCreated) {
            this.createTable();
        }
        log.info("Finished table [" + this.tableInfo.getName() + "].");
    }

    public void processCharacters(char[] ch, int start, int length) throws SAXException {
    }

    public SAXTagHandler startChildElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (!Constants.JDBC2XML_NS_URI.equals(uri) && !Constants.W3_XINCLUDE_NS_URI.equals(uri)) {
            throw new SAXException("Namspace URI [" + uri + "] is not supported.");
        }
        if (Constants.COLSET_TAG_NAME.equals(localName)) {
            return new ColumnSetTagHandler(this.tableInfo);
        }
        if (Constants.PRIMARY_KEY_TAG_NAME.equals(localName)) {
            this.tableInfo.setPrimaryKey(new PrimaryKeyInfo(atts));
            return null;
        }
        if (Constants.INDEXSET_TAG_NAME.equals(localName)) {
            return new IndexSetTagHandler(this.tableInfo);
        }
        if (Constants.FOREIGN_KEYS_TAG_NAME.equals(localName)) {
            return new ForeignKeySetTagHandler(this.tableInfo);
        }
        if (Constants.ROWSET_TAG_NAME.equals(localName)) {
            if (this.context.getProcessRestrictionFilter().isProcessData()) {
                if (!this.tableCreated) {
                    this.createTable();
                }
                return new RowSetTagHandler(this.context, this.tableInfo);
            }
            log.info("Ignoring rowset of table [" + this.tableInfo.getName() + "], because --no-data has been specified.");
            return null;
        }
        throw new SAXException("xmldump child element [" + localName + "] is not supported.");
    }
}

