/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.sax.impl.InsertContext;
import org.clazzes.jdbc2xml.sax.impl.ValueTagHandler;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RowTagHandler
implements SAXTagHandler {
    private static final Logger log = LoggerFactory.getLogger(RowTagHandler.class);
    private final InsertContext context;
    private final TableInfo tableInfo;
    private PreparedStatement insert;
    private int lastInsertedRow;
    private int unexecutedInserts;
    private final ValueTagHandler[] valueHandlers;

    public RowTagHandler(InsertContext context, TableInfo tableInfo) throws SAXException {
        this.context = context;
        this.tableInfo = tableInfo;
        this.unexecutedInserts = 0;
        this.lastInsertedRow = 0;
        try {
            this.insert = this.context.getSchemaEngine().createInsertStatement(this.tableInfo, true);
        }
        catch (SQLException e) {
            throw new SAXException("SQL error preparing insert statement for table [" + this.tableInfo.getName() + "].", e);
        }
        int nColumns = this.tableInfo.getColumns().size();
        this.valueHandlers = new ValueTagHandler[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            this.valueHandlers[i] = new ValueTagHandler(this.tableInfo.getColumns().get(i), this.context.getTimeZone(), this.insert, i + 1);
        }
    }

    public void flush(boolean closeInsert) throws SAXException {
        if (this.unexecutedInserts > 0) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Batch-inserting rows [" + (this.lastInsertedRow + 1) + "-" + (this.lastInsertedRow + this.unexecutedInserts) + "] into table [" + this.tableInfo.getName() + "].");
                }
                this.insert.executeBatch();
                if (this.context.getProcessRestrictionFilter().isTransactional()) {
                    this.context.getSchemaEngine().getConnection().commit();
                }
                this.insert.clearBatch();
                this.lastInsertedRow += this.unexecutedInserts;
                this.unexecutedInserts = 0;
            }
            catch (SQLException e) {
                throw new SAXException("Error inserting rows [" + (this.lastInsertedRow + 1) + "-" + (this.lastInsertedRow + this.unexecutedInserts) + "] into table [" + this.tableInfo.getName() + "].", e);
            }
        }
        if (!closeInsert) {
            return;
        }
        try {
            this.insert.close();
        }
        catch (SQLException e) {
            throw new SAXException("Error closing insert statement for table [" + this.tableInfo.getName() + "].", e);
        }
        log.info("Successfully inserted [" + this.lastInsertedRow + "] rows into table [" + this.tableInfo.getName() + "].");
    }

    public void closeTag(String uri, String localName, String name) throws SAXException {
        int nColumns = this.tableInfo.getColumns().size();
        for (int i = 0; i < nColumns; ++i) {
            this.valueHandlers[i].finishTag();
        }
        int batchSize = this.context.getProcessRestrictionFilter().getBatchSize();
        try {
            this.insert.addBatch();
        }
        catch (SQLException e) {
            throw new SAXException("SQL exception adding batch for upcoming row [" + (this.lastInsertedRow + this.unexecutedInserts + 1) + "] into table [" + this.tableInfo.getName() + "].", e);
        }
        ++this.unexecutedInserts;
        if (this.unexecutedInserts >= batchSize) {
            this.flush(false);
        }
    }

    public void processCharacters(char[] ch, int start, int length) throws SAXException {
    }

    public SAXTagHandler startChildElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (!Constants.JDBC2XML_NS_URI.equals(uri)) {
            throw new SAXException("Namspace URI [" + uri + "] is not supported.");
        }
        if (Constants.VALUE_TAG_NAME.equals(localName)) {
            int col = Integer.parseInt(atts.getValue(Constants.VALUE_TAG_COL_ATT));
            ValueTagHandler handler = this.valueHandlers[col];
            handler.startTag();
            return handler;
        }
        throw new SAXException("rowset child element [" + localName + "] is not supported.");
    }
}

