/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.schema.SortableTableDescription;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.TableSorter;
import org.clazzes.jdbc2xml.serialization.ISerializationHandlerFactory;
import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.clazzes.jdbc2xml.serialization.SerializationHandlerFactory;
import org.clazzes.jdbc2xml.sql.ISqlIdentifierMapperFactory;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapperFactory;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JDBCToSAXWriter {
    private static final Logger log = LoggerFactory.getLogger(JDBCToSAXWriter.class);
    private static final ISerializationHandlerFactory serializationHandlerFactory = SerializationHandlerFactory.newInstance();
    private static final ISqlIdentifierMapperFactory sqlIdentifierMapperFactory = SqlIdentifierMapperFactory.newInstance();
    private List<StatementInfo> statements;
    private ISchemaEngine schemaEngine;
    private SqlIdentifierMapper sqlIdentifierMapper;
    private ContentHandler contentHandler;
    private ProcessRestrictionFilter processRestrictionFilter = new ProcessRestrictionFilter();

    public JDBCToSAXWriter() {
    }

    public JDBCToSAXWriter(Connection connection, TimeZone timeZone, ContentHandler contentHandler) throws SQLException {
        this(SchemaEngine.newInstance(), contentHandler);
        this.schemaEngine.setConnection(connection);
        this.schemaEngine.setTimeZone(timeZone);
    }

    public JDBCToSAXWriter(ISchemaEngine schemaEngine, ContentHandler contentHandler) throws SQLException {
        this();
        this.schemaEngine = schemaEngine;
        this.contentHandler = contentHandler;
    }

    public Connection getConnection() {
        return this.schemaEngine.getConnection();
    }

    public void setConnection(Connection connection) throws SQLException {
        this.schemaEngine.setConnection(connection);
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public TimeZone getTimeZone() {
        return this.schemaEngine.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.schemaEngine.setTimeZone(timeZone);
    }

    public String getSchema() {
        return this.schemaEngine.getSchema();
    }

    public void setSchema(String schema) {
        this.schemaEngine.setSchema(schema);
    }

    private TableInfo makeTableInfo(String table) throws SQLException {
        return this.schemaEngine.fetchTableInfo(table, this.processRestrictionFilter);
    }

    public void addTables(Collection<String> tables) throws SQLException {
        for (String table : tables) {
            this.addTable(table);
        }
    }

    public void addTable(String table) throws SQLException {
        this.addTable(this.makeTableInfo(table));
    }

    public void addTable(TableInfo tableInfo) throws SQLException {
        if (this.statements == null) {
            this.statements = new LinkedList<StatementInfo>();
        }
        String sql = "select * from " + tableInfo.getName();
        this.statements.add(new StatementInfo(sql, tableInfo));
    }

    public void addRestrictedTable(String table, String sql) throws SQLException {
        if (this.statements == null) {
            this.statements = new LinkedList<StatementInfo>();
        }
        this.statements.add(new StatementInfo(sql, this.makeTableInfo(table)));
    }

    public void addQueries(Collection<String> queries) {
        for (String sql : queries) {
            this.addQuery(sql);
        }
    }

    public void addQuery(String sql) {
        if (this.statements == null) {
            this.statements = new LinkedList<StatementInfo>();
        }
        this.statements.add(new StatementInfo(sql, null));
    }

    private static void addAttr(AttributesImpl atts, String key, String value) {
        atts.addAttribute("", "", key, "CDATA", value);
    }

    private void startElement(String tag, Attributes atts) throws SAXException {
        this.contentHandler.startElement(Constants.JDBC2XML_NS_URI, tag, tag, atts);
    }

    private void endElement(String tag) throws SAXException {
        this.contentHandler.endElement(Constants.JDBC2XML_NS_URI, tag, tag);
    }

    private void emptyElement(String tag, Attributes atts) throws SAXException {
        this.startElement(tag, atts);
        this.endElement(tag);
    }

    private void writeForeignKeys(List<ForeignKeyInfo> fkInfos) throws SAXException {
        this.startElement(Constants.FOREIGN_KEYS_TAG_NAME, null);
        for (ForeignKeyInfo fkInfo : fkInfos) {
            this.emptyElement(Constants.FOREIGN_KEY_TAG_NAME, fkInfo.toAttributes(this.sqlIdentifierMapper));
        }
        this.endElement(Constants.FOREIGN_KEYS_TAG_NAME);
    }

    private void writeIndices(List<IndexInfo> indexInfos) throws SAXException {
        this.startElement(Constants.INDEXSET_TAG_NAME, null);
        for (IndexInfo indexInfo : indexInfos) {
            this.emptyElement(Constants.INDEX_TAG_NAME, indexInfo.toAttributes(this.sqlIdentifierMapper));
        }
        this.endElement(Constants.INDEXSET_TAG_NAME);
    }

    private void writeTableContraints(TableInfo tableInfo) throws SAXException {
        if (tableInfo.getPrimaryKey() != null) {
            this.emptyElement(Constants.PRIMARY_KEY_TAG_NAME, tableInfo.getPrimaryKey().toAttributes(this.sqlIdentifierMapper));
        }
        if (tableInfo.getIndices() != null) {
            this.writeIndices(tableInfo.getIndices());
        }
        if (this.processRestrictionFilter.isProcessConstraints() && tableInfo.getForeignKeys() != null) {
            this.writeForeignKeys(tableInfo.getForeignKeys());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData() throws SQLException, SAXException {
        List<String> tmpTableNameList;
        int n;
        if (this.sqlIdentifierMapper == null) {
            this.sqlIdentifierMapper = sqlIdentifierMapperFactory.newMapper(this.processRestrictionFilter.getIdMapper());
        }
        if ((n = (tmpTableNameList = this.schemaEngine.getTempTableNames()).size()) > 0) {
            String[] tmpTableNames = new String[n];
            for (int i = 0; i < n; ++i) {
                tmpTableNames[i] = tmpTableNameList.get(i);
            }
            this.processRestrictionFilter.setExcludedTableNames(tmpTableNames);
        }
        Connection connection = this.schemaEngine.getConnection();
        boolean oldReadOnly = connection.isReadOnly();
        int oldIsolationLevel = connection.getTransactionIsolation();
        try {
            List<StatementInfo> statementsWritten;
            if (!oldReadOnly) {
                connection.setReadOnly(true);
            }
            if (this.processRestrictionFilter.isTransactional()) {
                log.info("Starting a read-only transaction.");
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting the transaction isolation level to [8].");
                    }
                    connection.setTransactionIsolation(8);
                }
                catch (SQLException e) {
                    log.warn("TRANSACTION_SERIALIZABLE isolation level not supported, expect inconsistent result despite.", (Throwable)e);
                    oldIsolationLevel = 0;
                }
                connection.setAutoCommit(false);
            }
            log.info("Writing catalog [" + this.schemaEngine.getConnection().getCatalog() + "] to XML...");
            if (this.statements == null) {
                List<TableInfo> tables = this.schemaEngine.fetchTableInfos(this.processRestrictionFilter);
                statementsWritten = new ArrayList<StatementInfo>(tables.size());
                for (TableInfo ti : tables) {
                    String sql = "select * from " + ti.getName();
                    String whereClause = this.processRestrictionFilter.getTableClause(ti.getName());
                    if (whereClause != null) {
                        sql = sql + " WHERE " + whereClause;
                    }
                    statementsWritten.add(new StatementInfo(sql, ti));
                }
            } else {
                statementsWritten = this.statements;
            }
            TableSorter.sortTablesByFKDepth(statementsWritten);
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping("", Constants.JDBC2XML_NS_URI);
            this.contentHandler.startPrefixMapping("xi", Constants.W3_XINCLUDE_NS_URI);
            this.startElement(Constants.TOP_TAG_NAME, null);
            for (StatementInfo info : statementsWritten) {
                long count;
                block51: {
                    AttributesImpl atts = new AttributesImpl();
                    if (info.getTableInfo() == null) {
                        log.info("Writing query [" + info.sql + "]...");
                        JDBCToSAXWriter.addAttr(atts, Constants.QUERY_TAG_SQL_ATT, this.sqlIdentifierMapper.toExternal(info.sql));
                        this.startElement(Constants.QUERY_TAG_NAME, atts);
                    } else {
                        log.info("Writing table [" + info.getTableInfo().getName() + "]...");
                        JDBCToSAXWriter.addAttr(atts, Constants.TABLE_TAG_NAME_ATT, this.sqlIdentifierMapper.toExternal(info.getTableInfo().getName()));
                        if (info.getTableInfo().getComment() != null) {
                            JDBCToSAXWriter.addAttr(atts, Constants.TABLE_TAG_COMMENT_ATT, info.getTableInfo().getComment());
                        }
                        this.startElement(Constants.TABLE_TAG_NAME, atts);
                    }
                    count = 0L;
                    if (info.getTableInfo() == null || this.processRestrictionFilter.isProcessData()) {
                        try (Statement statement = connection.createStatement(1003, 1007);){
                            statement.setFetchSize(this.processRestrictionFilter.getBatchSize());
                            try (ResultSet resultSet = statement.executeQuery(info.sql);){
                                int column;
                                ResultSetMetaData metaData = resultSet.getMetaData();
                                SerializationHandler[] handlers = new SerializationHandler[metaData.getColumnCount()];
                                this.startElement(Constants.COLSET_TAG_NAME, null);
                                for (column = 0; column < metaData.getColumnCount(); ++column) {
                                    ColumnInfo ci;
                                    if (info.getTableInfo() != null) {
                                        ci = info.getTableInfo().getColumnInfo(metaData.getColumnName(column + 1));
                                        if (ci == null) {
                                            throw new SQLException("Column [" + metaData.getColumnName(column + 1) + "] of query [" + info.sql + "] could not be found in the metadata for table [" + info.getTableInfo().getName() + "].");
                                        }
                                    } else {
                                        ci = new ColumnInfo(metaData, column + 1);
                                    }
                                    handlers[column] = serializationHandlerFactory.newSerializationHandler(ci, this.getTimeZone());
                                    if (handlers[column] == null) {
                                        throw new SQLException("Unsupported type [" + TypesHelper.typeToString(ci.getType()) + "] in column [" + (column + 1) + "] of query [" + info.sql + "].");
                                    }
                                    this.emptyElement(Constants.COLUMN_TAG_NAME, ci.toAttributes(this.sqlIdentifierMapper));
                                }
                                this.endElement(Constants.COLSET_TAG_NAME);
                                if (info.getTableInfo() != null) {
                                    this.writeTableContraints(info.getTableInfo());
                                }
                                this.startElement(Constants.ROWSET_TAG_NAME, null);
                                while (resultSet.next()) {
                                    ++count;
                                    this.startElement(Constants.ROW_TAG_NAME, null);
                                    for (column = 0; column < metaData.getColumnCount(); ++column) {
                                        handlers[column].fetchData(resultSet, column + 1);
                                        if (handlers[column].isNull()) continue;
                                        atts = new AttributesImpl();
                                        JDBCToSAXWriter.addAttr(atts, Constants.VALUE_TAG_COL_ATT, Integer.toString(column));
                                        this.startElement(Constants.VALUE_TAG_NAME, atts);
                                        handlers[column].pushData(this.contentHandler);
                                        this.endElement(Constants.VALUE_TAG_NAME);
                                    }
                                    this.endElement(Constants.ROW_TAG_NAME);
                                }
                                this.endElement(Constants.ROWSET_TAG_NAME);
                                break block51;
                            }
                        }
                    }
                    this.startElement(Constants.COLSET_TAG_NAME, null);
                    for (ColumnInfo ci : info.getTableInfo().getColumns()) {
                        this.emptyElement(Constants.COLUMN_TAG_NAME, ci.toAttributes(this.sqlIdentifierMapper));
                    }
                    this.endElement(Constants.COLSET_TAG_NAME);
                    this.writeTableContraints(info.getTableInfo());
                    count = -1L;
                }
                if (info.getTableInfo() == null) {
                    this.endElement(Constants.QUERY_TAG_NAME);
                    log.info("[" + count + "] rows of query [" + info.sql + "] have been successfully written.");
                    continue;
                }
                this.endElement(Constants.TABLE_TAG_NAME);
                if (count >= 0L) {
                    log.info("[" + count + "] rows of table [" + info.getTableInfo().getName() + "] have been successfully written.");
                    continue;
                }
                log.info("Table [" + info.getTableInfo().getName() + "] has been successfully written.");
            }
            this.endElement(Constants.TOP_TAG_NAME);
            this.contentHandler.endPrefixMapping("");
            this.contentHandler.endPrefixMapping("xi");
            this.contentHandler.endDocument();
            log.info("Finished writing catalog [" + this.schemaEngine.getConnection().getCatalog() + "] to XML.");
        }
        finally {
            if (this.processRestrictionFilter.isTransactional()) {
                log.info("Closing the read-only transaction.");
                connection.setAutoCommit(true);
                if (oldIsolationLevel != 0 && oldIsolationLevel != connection.getTransactionIsolation()) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Resetting the transaction isolation level to [" + oldIsolationLevel + "].");
                        }
                        connection.setTransactionIsolation(oldIsolationLevel);
                    }
                    catch (SQLException e) {
                        log.warn("Error resetting the transaction isolation level to [" + oldIsolationLevel + "].", (Throwable)e);
                    }
                }
            }
            if (!oldReadOnly) {
                connection.setReadOnly(false);
            }
        }
    }

    public ProcessRestrictionFilter getProcessRestrictionFilter() {
        return this.processRestrictionFilter;
    }

    public void setProcessRestrictionFilter(ProcessRestrictionFilter processFilter) {
        this.processRestrictionFilter = processFilter;
        this.sqlIdentifierMapper = null;
        this.schemaEngine.getDialect().setProperties(processFilter.getDialectProps());
    }

    private static class StatementInfo
    extends SortableTableDescription {
        public final String sql;

        public StatementInfo(String sql, TableInfo tableInfo) {
            super(tableInfo);
            this.sql = sql;
        }
    }
}

